/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.filtering;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.atteo.evo.filtering.PropertyNotFoundException;
import org.atteo.evo.filtering.SimplePropertyResolver;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlPropertyResolver
extends SimplePropertyResolver {
    private Element rootElement;
    private boolean matchRoot;

    public XmlPropertyResolver(@Nullable Element rootElement, boolean matchRoot) {
        this.rootElement = rootElement;
        this.matchRoot = matchRoot;
    }

    @Override
    public String getProperty(String name) throws PropertyNotFoundException {
        String value = this.getValue(name);
        if (value == null) {
            return null;
        }
        return value;
    }

    private String getValue(String name) {
        int dotIndex;
        int index;
        if (this.rootElement == null) {
            return null;
        }
        int position = 0;
        ArrayList<Integer> dots = new ArrayList<Integer>();
        while ((index = name.indexOf(".", position)) != -1) {
            dots.add(index);
            position = index + 1;
        }
        dots.add(name.length());
        Element element = this.rootElement;
        if (this.matchRoot) {
            if (!this.rootElement.getNodeName().equals(name.substring(0, (Integer)dots.get(0)))) {
                return null;
            }
            position = (Integer)dots.get(0) + 1;
            dotIndex = 0;
        } else {
            position = 0;
            dotIndex = -1;
        }
        block1: while (position < name.length()) {
            String key = name.substring(position);
            if (element.hasAttribute(key)) {
                return element.getAttribute(key);
            }
            for (int i = dots.size() - 1; i > dotIndex; --i) {
                key = name.substring(position, (Integer)dots.get(i));
                NodeList list = element.getElementsByTagName(key);
                if (list.getLength() != 1) continue;
                element = (Element)list.item(0);
                position = (Integer)dots.get(i) + 1;
                dotIndex = i;
                continue block1;
            }
            return null;
        }
        return element.getTextContent();
    }
}

