/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.jaxb;

import java.lang.reflect.Field;
import javax.annotation.Nullable;
import javax.xml.bind.Binder;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxbBindings {
    private Binder binder;
    private Runnable runnable;

    private JaxbBindings(Binder binder, Runnable runnable) {
        this.binder = binder;
        this.runnable = runnable;
    }

    public static void iterate(Element root, Binder binder, Runnable runnable) {
        Object object = binder.getJAXBNode((Object)root);
        JaxbBindings bindRecurse = new JaxbBindings(binder, runnable);
        try {
            bindRecurse.recurse(root, object, null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void recurse(Element element, Object object, @Nullable Field field) throws IllegalAccessException {
        this.runnable.run(element, object, field);
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Field f;
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            Object child = this.binder.getJAXBNode((Object)node);
            if (child != null) {
                f = JaxbBindings.findFieldByValue(object, child);
            } else {
                f = JaxbBindings.findFieldByXmlElementWrapper(object, e.getTagName());
                if (f == null) continue;
                child = f.get(object);
            }
            this.recurse(e, child, f);
        }
    }

    private static Field findFieldByValue(Object object, Object child) throws IllegalAccessException {
        for (Class<?> klass = object.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            for (Field field : klass.getDeclaredFields()) {
                field.setAccessible(true);
                if (field.get(object) != child) continue;
                return field;
            }
        }
        return null;
    }

    private static Field findFieldByXmlElementWrapper(Object object, String name) throws IllegalAccessException {
        for (Class<?> klass = object.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            for (Field field : klass.getDeclaredFields()) {
                field.setAccessible(true);
                XmlElementWrapper annotation = field.getAnnotation(XmlElementWrapper.class);
                if (annotation == null || !name.equals(annotation.name())) continue;
                return field;
            }
        }
        return null;
    }

    public static interface Runnable {
        public void run(Element var1, Object var2, @Nullable Field var3);
    }
}

