/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.jaxb;

import com.sun.xml.bind.IDResolver;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ScopedIdResolver
extends IDResolver {
    private Map<Key, Object> map = new HashMap<Key, Object>();
    private ValidationEventHandler eventHandler = null;

    public void startDocument(ValidationEventHandler eventHandler) throws SAXException {
        super.startDocument(eventHandler);
        this.eventHandler = eventHandler;
    }

    public void endDocument() throws SAXException {
        this.map.clear();
        this.eventHandler = null;
        super.endDocument();
    }

    public void bind(String id, Object object) throws SAXException {
        for (Class<?> klass = object.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            Key key = new Key(klass, id);
            Object value = this.map.get(key);
            if (value != null) {
                if (value == Values.NON_UNIQUE) continue;
                this.map.put(key, (Object)Values.NON_UNIQUE);
                continue;
            }
            this.map.put(key, object);
        }
    }

    public Callable<?> resolve(final String id, final Class targetType) throws SAXException {
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Key key = new Key(targetType, id);
                Object value = ScopedIdResolver.this.map.get(key);
                if (value == Values.NON_UNIQUE) {
                    NotUniqueIdValidationEvent event = new NotUniqueIdValidationEvent(key);
                    if (!ScopedIdResolver.this.eventHandler.handleEvent((ValidationEvent)event)) {
                        throw new SAXException(event.getMessage());
                    }
                }
                return value;
            }
        };
    }

    private static enum Values {
        NON_UNIQUE;

    }

    private static class NotUniqueIdValidationEvent
    implements ValidationEvent {
        private Key key;

        public NotUniqueIdValidationEvent(Key key) {
            this.key = key;
        }

        public int getSeverity() {
            return 2;
        }

        public String getMessage() {
            return "Cannot resolve XmlIDREF because pair [" + this.key.klass + ", id = \"" + this.key.id + "\"] is not unique";
        }

        public Throwable getLinkedException() {
            return null;
        }

        public ValidationEventLocator getLocator() {
            return new ValidationEventLocator(){

                public URL getURL() {
                    return null;
                }

                public int getOffset() {
                    return 0;
                }

                public int getLineNumber() {
                    return -1;
                }

                public int getColumnNumber() {
                    return -1;
                }

                public Object getObject() {
                    return null;
                }

                public Node getNode() {
                    return null;
                }
            };
        }
    }

    private static class Key {
        private Class<?> klass;
        private String id;

        public Key(Class<?> klass, String id) {
            this.klass = klass;
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!(this.klass == other.getClass() || this.klass != null && this.klass.equals(other.getKlass()))) {
                return false;
            }
            return !(this.id == null ? other.getId() != null : !this.id.equals(other.getId()));
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.klass != null ? this.klass.hashCode() : 0);
            hash = 29 * hash + (this.id != null ? this.id.hashCode() : 0);
            return hash;
        }

        public String getId() {
            return this.id;
        }

        public Class<?> getKlass() {
            return this.klass;
        }
    }
}

