/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.inflector;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TwoFormInflector {
    private List<Rule> rules = new ArrayList<Rule>();

    protected String getPlural(String word) {
        StringBuffer buffer = new StringBuffer();
        for (Rule rule : this.rules) {
            Matcher matcher = rule.getSingular().matcher(word);
            if (!matcher.find()) continue;
            matcher.appendReplacement(buffer, rule.getPlural());
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        return null;
    }

    protected void uncountable(String word) {
        this.rules.add(new Rule(Pattern.compile("(?i)(" + word + ")$"), "$1"));
    }

    protected void uncountable(String[] list) {
        StringBuilder builder = new StringBuilder();
        builder.append("(?i)(");
        builder.append(list[0]);
        for (String word : list) {
            builder.append("|").append(word);
        }
        builder.append(")$");
        this.rules.add(new Rule(Pattern.compile(builder.toString()), "$1"));
    }

    protected void irregular(String singular, String plural) {
        if (singular.charAt(0) == plural.charAt(0)) {
            this.rules.add(new Rule(Pattern.compile("(?i)(" + singular.charAt(0) + ")" + singular.substring(1) + "$"), "$1" + plural.substring(1)));
        } else {
            this.rules.add(new Rule(Pattern.compile(Character.toUpperCase(singular.charAt(0)) + "(?i)" + singular.substring(1) + "$"), Character.toUpperCase(plural.charAt(0)) + plural.substring(1)));
            this.rules.add(new Rule(Pattern.compile(Character.toLowerCase(singular.charAt(0)) + "(?i)" + singular.substring(1) + "$"), Character.toLowerCase(plural.charAt(0)) + plural.substring(1)));
        }
    }

    protected void irregular(String[][] list) {
        for (String[] pair : list) {
            this.irregular(pair[0], pair[1]);
        }
    }

    protected void rule(String singular, String plural) {
        this.rules.add(new Rule(Pattern.compile(singular, 2), plural));
    }

    protected void rule(String[][] list) {
        for (String[] pair : list) {
            this.rules.add(new Rule(Pattern.compile(pair[0], 2), pair[1]));
        }
    }

    protected void categoryRule(String[] list, String singular, String plural) {
        StringBuilder builder = new StringBuilder();
        builder.append("(?=").append(list[0]);
        for (String word : list) {
            builder.append("|").append(word);
        }
        builder.append(")");
        builder.append(singular);
        this.rules.add(new Rule(Pattern.compile(builder.toString(), 2), plural));
    }

    private static class Rule {
        private Pattern singular;
        private String plural;

        private Rule(Pattern singular, String plural) {
            this.singular = singular;
            this.plural = plural;
        }

        public Pattern getSingular() {
            return this.singular;
        }

        public String getPlural() {
            return this.plural;
        }
    }
}

