/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.jetty;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.servlet.DispatcherType;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.evo.classindex.ClassIndex;
import org.atteo.evo.services.ContentDirectory;
import org.atteo.evo.services.ExternalContainer;
import org.atteo.evo.services.TopLevelService;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.BlockingChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.log.Log;

@XmlRootElement(name="jetty")
public class Jetty
extends TopLevelService {
    @XmlElement
    private Integer port = 8080;
    @XmlElement
    private String welcomeFile = "Application.html";
    @Inject
    private Injector injector;
    @Inject(optional=true)
    private MBeanServer mbeanServer;
    @Inject
    @ExternalContainer
    private Boolean externalContainer;
    @Inject(optional=true)
    @ContentDirectory
    private File warDirectory;
    private Server server;

    public Module configure() {
        return new ServletModule(){

            protected void configureServlets() {
                String[] restOfUrls;
                HashMap<String, String> params;
                String[] urls;
                WebServlet annotation;
                for (Class klass : ClassIndex.getAnnotated(WebServlet.class)) {
                    annotation = klass.getAnnotation(WebServlet.class);
                    urls = annotation.value();
                    if (urls.length == 0) {
                        urls = annotation.urlPatterns();
                    }
                    params = new HashMap<String, String>();
                    for (WebInitParam param : annotation.initParams()) {
                        params.put(param.name(), param.value());
                    }
                    restOfUrls = Arrays.copyOfRange(urls, 1, urls.length - 1);
                    Class servletClass = klass;
                    this.serve(urls[0], restOfUrls).with(servletClass, params);
                    this.bind(servletClass).in(Singleton.class);
                }
                for (Class klass : ClassIndex.getAnnotated(WebFilter.class)) {
                    annotation = klass.getAnnotation(WebFilter.class);
                    urls = annotation.value();
                    if (urls.length == 0) {
                        urls = annotation.urlPatterns();
                    }
                    params = new HashMap();
                    for (WebInitParam param : annotation.initParams()) {
                        params.put(param.name(), param.value());
                    }
                    restOfUrls = Arrays.copyOfRange(urls, 1, urls.length - 1);
                    Class filterClass = klass;
                    this.filter(urls[0], restOfUrls).through(filterClass, params);
                    this.bind(filterClass).in(Singleton.class);
                }
            }
        };
    }

    public void start() {
        if (this.externalContainer.booleanValue()) {
            return;
        }
        this.server = new Server();
        ServletContextHandler servlets = new ServletContextHandler(1);
        servlets.setResourceBase(this.warDirectory.getAbsolutePath());
        servlets.addFilter(GuiceFilter.class, "/*", EnumSet.noneOf(DispatcherType.class));
        servlets.addEventListener((EventListener)new GuiceServletContextListener(){

            protected Injector getInjector() {
                return Jetty.this.injector;
            }
        });
        servlets.addServlet(DefaultServlet.class, "/");
        ResourceHandler resources = new ResourceHandler();
        resources.setWelcomeFiles(new String[]{this.welcomeFile});
        resources.setResourceBase(this.warDirectory.getAbsolutePath());
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)resources);
        handlers.addHandler((Handler)servlets);
        this.server.setHandler((Handler)handlers);
        BlockingChannelConnector connector = new BlockingChannelConnector();
        connector.setPort(this.port.intValue());
        this.server.addConnector((Connector)connector);
        if (this.mbeanServer != null) {
            MBeanContainer mbContainer = new MBeanContainer(this.mbeanServer);
            this.server.getContainer().addEventListener((Container.Listener)mbContainer);
            this.server.addBean((Object)mbContainer);
            mbContainer.addBean((Object)Log.getLog());
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

