/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.tests;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.servlet.GuiceFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.atteo.evo.services.Services;
import org.atteo.evo.tests.Bindings;
import org.atteo.evo.tests.Mock;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.mockito.Mockito;

public class ServicesRule
implements MethodRule {
    private String config;
    private Services services;

    public ServicesRule() {
    }

    public ServicesRule(String config) {
        this.config = config;
    }

    public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ServicesRule.this.configure(target);
                try {
                    base.evaluate();
                }
                finally {
                    ServicesRule.this.deconfigure();
                }
            }
        };
    }

    private void configure(final Object target) {
        Field[] fields;
        TestClass testClass = new TestClass(target.getClass());
        final List bindingsMethods = testClass.getAnnotatedMethods(Bindings.class);
        Module bindingsModule = new Module(){

            public void configure(Binder binder) {
                for (int i = 0; i < bindingsMethods.size(); ++i) {
                    FrameworkMethod method = (FrameworkMethod)bindingsMethods.get(i);
                    method.getMethod().setAccessible(true);
                    try {
                        method.invokeExplosively(target, new Object[]{binder});
                        continue;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        Class<?> klass = target.getClass();
        final HashMap mocks = new HashMap();
        for (Field field : fields = klass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Mock.class)) continue;
            Object m = Mockito.mock(field.getType());
            if (field.isAnnotationPresent(Inject.class) || field.isAnnotationPresent(javax.inject.Inject.class)) {
                mocks.put(field.getType(), m);
            }
            field.setAccessible(true);
            try {
                field.set(target, m);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Module mocksModule = new Module(){

            public void configure(Binder binder) {
                Set keys = mocks.keySet();
                for (Class klass : keys) {
                    TypeLiteral t = TypeLiteral.get((Class)klass);
                    Object o = mocks.get(klass);
                    binder.bind(t).toInstance(o);
                }
            }
        };
        InputStream stream = this.config != null ? target.getClass().getResourceAsStream(this.config) : target.getClass().getResourceAsStream("/test-config.xml");
        if (stream == null && this.config != null) {
            throw new RuntimeException("Configuration resource not found: " + this.config);
        }
        this.services = new Services(new File("target/test-home/"), new File("src/main/webapp/"), stream);
        this.services.addModule(bindingsModule);
        this.services.addModule(mocksModule);
        this.services.start();
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.services.injector().injectMembers(target);
    }

    private void deconfigure() {
        if (this.services != null) {
            this.services.stop();
        }
        new GuiceFilter().destroy();
    }
}

