/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.xmlcombiner;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.atteo.xmlcombiner.Key;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Context {
    public static final String KEYS_ATTRIBUTE_NAME = "combine.keys";
    public static final String ID_ATTRIBUTE_NAME = "combine.id";
    private final List<Node> neighbours = new ArrayList<Node>();
    private Element element;

    public static Context fromElement(Element element) {
        Context context = new Context();
        context.setElement(element);
        return context;
    }

    public void addNeighbour(Node node) {
        this.neighbours.add(node);
    }

    public List<Node> getNeighbours() {
        return this.neighbours;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public void addAsChildTo(Node node) {
        for (Node neighbour : this.neighbours) {
            node.appendChild(neighbour);
        }
        node.appendChild(this.element);
    }

    public void addAsChildTo(Node node, Document document) {
        for (Node neighbour : this.neighbours) {
            node.appendChild(document.importNode(neighbour, true));
        }
        if (this.element != null) {
            node.appendChild(document.importNode(this.element, true));
        }
    }

    public List<Context> groupChildContexts() {
        if (this.element == null) {
            return Collections.emptyList();
        }
        NodeList nodes = this.element.getChildNodes();
        ArrayList<Context> contexts = new ArrayList<Context>(nodes.getLength());
        Context context = new Context();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                context.setElement((Element)node);
                contexts.add(context);
                context = new Context();
                continue;
            }
            context.addNeighbour(node);
        }
        contexts.add(context);
        return contexts;
    }

    public ListMultimap<Key, Context> mapChildContexts(List<String> keyAttributeNames) {
        List<Context> contexts = this.groupChildContexts();
        LinkedListMultimap map = LinkedListMultimap.create();
        for (Context context : contexts) {
            Element contextElement = context.getElement();
            if (contextElement != null) {
                HashMap<String, String> keys = new HashMap<String, String>();
                for (String keyAttributeName : keyAttributeNames) {
                    Attr keyNode = contextElement.getAttributeNode(keyAttributeName);
                    if (keyNode == null) continue;
                    keys.put(keyAttributeName, keyNode.getValue());
                }
                Attr keyNode = contextElement.getAttributeNode(ID_ATTRIBUTE_NAME);
                if (keyNode != null) {
                    keys.put(ID_ATTRIBUTE_NAME, keyNode.getValue());
                }
                Key key = new Key(contextElement.getTagName(), keys);
                map.put((Object)key, (Object)context);
                continue;
            }
            map.put((Object)Key.BEFORE_END, (Object)context);
        }
        return map;
    }

    public String toString() {
        return "[" + this.neighbours + ", " + this.element + "]";
    }
}

