/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.xmlcombiner;

import com.google.common.base.Splitter;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.atteo.xmlcombiner.CombineChildren;
import org.atteo.xmlcombiner.CombineSelf;
import org.atteo.xmlcombiner.Context;
import org.atteo.xmlcombiner.Key;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlCombiner {
    private final DocumentBuilder documentBuilder;
    private final Document document;
    private final List<String> defaultAttributeNames;
    private static final Filter NULL_FILTER = new Filter(){

        @Override
        public void postProcess(Element recessive, Element dominant, Element result) {
        }
    };
    private Filter filter = NULL_FILTER;

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        ArrayList<Path> files = new ArrayList<Path>();
        ArrayList<String> ids = new ArrayList<String>();
        boolean onlyFiles = false;
        for (int i = 0; i < args.length; ++i) {
            if (!onlyFiles) {
                switch (args[i]) {
                    case "--key": {
                        ids.add(args[i + 1]);
                        ++i;
                        break;
                    }
                    case "--": {
                        onlyFiles = true;
                        break;
                    }
                    default: {
                        files.add(Paths.get(args[i], new String[0]));
                        break;
                    }
                }
                continue;
            }
            files.add(Paths.get(args[i], new String[0]));
        }
        XmlCombiner xmlCombiner = new XmlCombiner(ids);
        for (Path file : files) {
            xmlCombiner.combine(file);
        }
        xmlCombiner.buildDocument(System.out);
    }

    public XmlCombiner() throws ParserConfigurationException {
        this(DocumentBuilderFactory.newInstance().newDocumentBuilder());
    }

    public XmlCombiner(DocumentBuilder documentBuilder) {
        this(documentBuilder, Lists.newArrayList());
    }

    public XmlCombiner(String idAttributeName) throws ParserConfigurationException {
        this(Lists.newArrayList((Object[])new String[]{idAttributeName}));
    }

    public XmlCombiner(List<String> keyAttributeNames) throws ParserConfigurationException {
        this(DocumentBuilderFactory.newInstance().newDocumentBuilder(), keyAttributeNames);
    }

    public XmlCombiner(DocumentBuilder documentBuilder, String keyAttributeNames) {
        this(documentBuilder, Lists.newArrayList((Object[])new String[]{keyAttributeNames}));
    }

    public XmlCombiner(DocumentBuilder documentBuilder, List<String> keyAttributeNames) {
        this.documentBuilder = documentBuilder;
        this.document = documentBuilder.newDocument();
        this.defaultAttributeNames = keyAttributeNames;
    }

    public void setFilter(Filter filter) {
        if (filter == null) {
            this.filter = NULL_FILTER;
            return;
        }
        this.filter = filter;
    }

    public void combine(Path file) throws SAXException, IOException {
        this.combine(this.documentBuilder.parse(file.toFile()));
    }

    public void combine(InputStream stream) throws SAXException, IOException {
        this.combine(this.documentBuilder.parse(stream));
    }

    public void combine(Document document) {
        this.combine(document.getDocumentElement());
    }

    public void combine(Element element) {
        Element parent = this.document.getDocumentElement();
        if (parent != null) {
            this.document.removeChild(parent);
        }
        Context result = this.combine(Context.fromElement(parent), Context.fromElement(element));
        result.addAsChildTo(this.document);
    }

    public Document buildDocument() {
        XmlCombiner.filterOutDefaults(Context.fromElement(this.document.getDocumentElement()));
        XmlCombiner.filterOutCombines(this.document.getDocumentElement());
        return this.document;
    }

    public void buildDocument(OutputStream out) throws TransformerException {
        Document result = this.buildDocument();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StreamResult output = new StreamResult(out);
        DOMSource input = new DOMSource(result);
        transformer.transform(input, output);
    }

    public void buildDocument(Path path) throws TransformerException, FileNotFoundException {
        this.buildDocument(new FileOutputStream(path.toFile()));
    }

    private Context combine(Context recessive, Context dominant) {
        Context combined;
        Key key;
        Attr keysNode;
        CombineSelf dominantCombineSelf = XmlCombiner.getCombineSelf(dominant.getElement());
        CombineSelf recessiveCombineSelf = XmlCombiner.getCombineSelf(recessive.getElement());
        if (dominantCombineSelf == CombineSelf.REMOVE) {
            return null;
        }
        if (dominantCombineSelf == CombineSelf.OVERRIDE || recessiveCombineSelf == CombineSelf.OVERRIDABLE) {
            Context result = this.copyRecursively(dominant);
            result.getElement().removeAttribute("combine.self");
            return result;
        }
        CombineChildren combineChildren = XmlCombiner.getCombineChildren(dominant.getElement());
        if (combineChildren == null && (combineChildren = XmlCombiner.getCombineChildren(recessive.getElement())) == null) {
            combineChildren = CombineChildren.MERGE;
        }
        if (combineChildren == CombineChildren.APPEND) {
            if (recessive.getElement() != null) {
                XmlCombiner.removeWhitespaceTail(recessive.getElement());
                this.appendRecursively(dominant, recessive);
                return recessive;
            }
            return this.copyRecursively(dominant);
        }
        Element resultElement = this.document.createElement(dominant.getElement().getTagName());
        this.copyAttributes(recessive.getElement(), resultElement);
        this.copyAttributes(dominant.getElement(), resultElement);
        CombineSelf combineSelf = dominantCombineSelf;
        if (combineSelf == null && recessiveCombineSelf != CombineSelf.DEFAULTS) {
            combineSelf = recessiveCombineSelf;
        }
        if (combineSelf != null) {
            resultElement.setAttribute("combine.self", combineSelf.name().toLowerCase());
        } else {
            resultElement.removeAttribute("combine.self");
        }
        List keys = this.defaultAttributeNames;
        if (recessive.getElement() != null && (keysNode = recessive.getElement().getAttributeNode("combine.keys")) != null) {
            keys = Splitter.on((String)",").splitToList((CharSequence)keysNode.getValue());
        }
        if (dominant.getElement() != null && (keysNode = dominant.getElement().getAttributeNode("combine.keys")) != null) {
            keys = Splitter.on((String)",").splitToList((CharSequence)keysNode.getValue());
        }
        ListMultimap<Key, Context> recessiveContexts = recessive.mapChildContexts(keys);
        ListMultimap<Key, Context> dominantContexts = dominant.mapChildContexts(keys);
        Set<String> tagNamesInDominant = XmlCombiner.getTagNames(dominantContexts);
        if (!recessiveContexts.isEmpty()) {
            for (Map.Entry entry : recessiveContexts.entries()) {
                key = (Key)entry.getKey();
                Context recessiveContext = (Context)entry.getValue();
                if (key == Key.BEFORE_END) continue;
                if (XmlCombiner.getCombineSelf(recessiveContext.getElement()) == CombineSelf.OVERRIDABLE_BY_TAG) {
                    if (tagNamesInDominant.contains(key.getName())) continue;
                    recessiveContext.addAsChildTo(resultElement);
                    this.filter.postProcess(recessiveContext.getElement(), null, recessiveContext.getElement());
                    continue;
                }
                if (dominantContexts.get((Object)key).size() == 1 && recessiveContexts.get((Object)key).size() == 1) {
                    Context dominantContext = (Context)dominantContexts.get((Object)key).iterator().next();
                    combined = this.combine(recessiveContext, dominantContext);
                    if (combined == null) continue;
                    combined.addAsChildTo(resultElement);
                    continue;
                }
                recessiveContext.addAsChildTo(resultElement);
                if (recessiveContext.getElement() == null) continue;
                this.filter.postProcess(recessiveContext.getElement(), null, recessiveContext.getElement());
            }
        }
        for (Map.Entry entry : dominantContexts.entries()) {
            key = (Key)entry.getKey();
            Context dominantContext = (Context)entry.getValue();
            if (key == Key.BEFORE_END) {
                dominantContext.addAsChildTo(resultElement, this.document);
                if (dominantContext.getElement() == null) continue;
                this.filter.postProcess(null, dominantContext.getElement(), dominantContext.getElement());
                continue;
            }
            List associatedRecessives = recessiveContexts.get((Object)key);
            if (dominantContexts.get((Object)key).size() == 1 && associatedRecessives.size() == 1 && XmlCombiner.getCombineSelf(((Context)associatedRecessives.get(0)).getElement()) != CombineSelf.OVERRIDABLE_BY_TAG || (combined = this.combine(Context.fromElement(null), dominantContext)) == null) continue;
            combined.addAsChildTo(resultElement);
        }
        Context result = new Context();
        result.setElement(resultElement);
        this.appendNeighbours(dominant, result);
        this.filter.postProcess(recessive.getElement(), dominant.getElement(), result.getElement());
        return result;
    }

    private Context copyRecursively(Context context) {
        Context copy = new Context();
        this.appendNeighbours(context, copy);
        Element element = (Element)this.document.importNode(context.getElement(), false);
        copy.setElement(element);
        this.appendRecursively(context, copy);
        return copy;
    }

    private void appendNeighbours(Context source, Context destination) {
        for (Node neighbour : source.getNeighbours()) {
            destination.addNeighbour(this.document.importNode(neighbour, true));
        }
    }

    private void appendRecursively(Context source, Context destination) {
        this.copyAttributes(source.getElement(), destination.getElement());
        List<Context> contexts = source.groupChildContexts();
        for (Context context : contexts) {
            if (context.getElement() == null) {
                context.addAsChildTo(destination.getElement(), this.document);
                continue;
            }
            Context combined = this.combine(Context.fromElement(null), context);
            if (combined == null) continue;
            combined.addAsChildTo(destination.getElement());
        }
    }

    private void copyAttributes(@Nullable Element source, Element destination) {
        if (source == null) {
            return;
        }
        NamedNodeMap attributes = source.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            Attr destAttribute = destination.getAttributeNodeNS(attribute.getNamespaceURI(), attribute.getName());
            if (destAttribute == null) {
                destination.setAttributeNodeNS((Attr)this.document.importNode(attribute, true));
                continue;
            }
            destAttribute.setValue(attribute.getValue());
        }
    }

    private static CombineSelf getCombineSelf(@Nullable Element element) {
        CombineSelf combine = null;
        if (element == null) {
            return null;
        }
        Attr combineAttribute = element.getAttributeNode("combine.self");
        if (combineAttribute != null) {
            try {
                combine = CombineSelf.valueOf(combineAttribute.getValue().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("The attribute 'combine' of element '" + element.getTagName() + "' has invalid value '" + combineAttribute.getValue(), e);
            }
        }
        return combine;
    }

    private static CombineChildren getCombineChildren(@Nullable Element element) {
        CombineChildren combine = null;
        if (element == null) {
            return null;
        }
        Attr combineAttribute = element.getAttributeNode("combine.children");
        if (combineAttribute != null) {
            try {
                combine = CombineChildren.valueOf(combineAttribute.getValue().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("The attribute 'combine' of element '" + element.getTagName() + "' has invalid value '" + combineAttribute.getValue(), e);
            }
        }
        return combine;
    }

    private static void removeWhitespaceTail(Element element) {
        Node node;
        NodeList list = element.getChildNodes();
        for (int i = list.getLength() - 1; i >= 0 && !((node = list.item(i)) instanceof Element); --i) {
            element.removeChild(node);
        }
    }

    private static void filterOutDefaults(Context context) {
        Element element = context.getElement();
        List<Context> childContexts = context.groupChildContexts();
        for (Context childContext : childContexts) {
            if (childContext.getElement() == null) continue;
            CombineSelf combineSelf = XmlCombiner.getCombineSelf(childContext.getElement());
            if (combineSelf == CombineSelf.DEFAULTS) {
                for (Node neighbour : childContext.getNeighbours()) {
                    element.removeChild(neighbour);
                }
                element.removeChild(childContext.getElement());
                continue;
            }
            XmlCombiner.filterOutDefaults(childContext);
        }
    }

    private static void filterOutCombines(Element element) {
        element.removeAttribute("combine.self");
        element.removeAttribute("combine.children");
        element.removeAttribute("combine.keys");
        element.removeAttribute("combine.id");
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!(item instanceof Element)) continue;
            XmlCombiner.filterOutCombines((Element)item);
        }
    }

    private static Set<String> getTagNames(ListMultimap<Key, Context> dominantContexts) {
        HashSet<String> names = new HashSet<String>();
        for (Key key : dominantContexts.keys()) {
            names.add(key.getName());
        }
        return names;
    }

    public static interface Filter {
        public void postProcess(Element var1, Element var2, Element var3);
    }
}

