/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.sql.pool;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.attribyte.api.InitializationException;
import org.attribyte.api.Logger;
import org.attribyte.sql.pool.ConnectionPool;
import org.attribyte.sql.pool.ConnectionPoolConnection;
import org.attribyte.sql.pool.ConnectionPoolSegment;
import org.attribyte.sql.pool.JDBConnection;
import org.attribyte.sql.pool.PasswordSource;

public class TypesafeConfig {
    static final int MISSING_INT = Integer.MIN_VALUE;
    static final long MISSING_LONG = Long.MIN_VALUE;

    public static void main(String[] args) throws Exception {
        File configFile = new File("/home/matt/hg/acp/doc/config/sample.config");
        Config rootConfig = ConfigFactory.parseFile((File)configFile);
        List<ConnectionPool.Initializer> pools = TypesafeConfig.poolsFromConfig(rootConfig, null, null);
        for (ConnectionPool.Initializer poolInit : pools) {
            ConnectionPool pool = poolInit.createPool();
            System.out.println(pool.getName());
            System.out.println("Total Segments: " + pool.getTotalSegments());
        }
    }

    static final String getString(Config config, String name) throws InitializationException {
        return TypesafeConfig.getString(config, name, null);
    }

    static final String getString(Config config, String name, String defaultValue) throws InitializationException {
        String val;
        try {
            val = config.hasPath(name) ? config.getString(name) : defaultValue;
        }
        catch (ConfigException ce) {
            throw new InitializationException(ce.getMessage());
        }
        if (val == null) {
            throw new InitializationException("The property, '" + name + "', must be supplied");
        }
        return val.trim();
    }

    static final int getInt(Config config, String name, int minValue) throws InitializationException {
        int val;
        try {
            val = config.hasPath(name) ? config.getInt(name) : Integer.MIN_VALUE;
        }
        catch (ConfigException ce) {
            throw new InitializationException(ce.getMessage());
        }
        if (val == Integer.MIN_VALUE) {
            throw new InitializationException("The property, '" + name + "', must be supplied");
        }
        if (val < minValue) {
            throw new InitializationException("The property, '" + name + "', must be > " + minValue);
        }
        return val;
    }

    static final long getMilliseconds(Config config, String name) throws InitializationException {
        long val;
        try {
            val = config.hasPath(name) ? config.getMilliseconds(name) : Long.MIN_VALUE;
        }
        catch (ConfigException ce) {
            throw new InitializationException(ce.getMessage());
        }
        if (val == Long.MIN_VALUE) {
            throw new InitializationException("The property, '" + name + "', must be supplied");
        }
        if (val < 0L) {
            throw new InitializationException("The property, '" + name + "', must not be negative");
        }
        return val;
    }

    static final Set<String> uniquePrefixSet(Config config) {
        HashSet prefixSet = Sets.newHashSet();
        for (Map.Entry entry : config.entrySet()) {
            String key = (String)entry.getKey();
            int index = key.indexOf(46);
            if (index <= 0) continue;
            String prefix = key.substring(0, index);
            prefixSet.add(prefix);
        }
        return prefixSet;
    }

    public static final Map<String, ConnectionPool> buildPools(Collection<ConnectionPool.Initializer> initializers) throws InitializationException, SQLException {
        HashMap poolMap = Maps.newHashMap();
        for (ConnectionPool.Initializer initializer : initializers) {
            ConnectionPool pool = initializer.createPool();
            poolMap.put(pool.getName(), pool);
        }
        return poolMap;
    }

    public static final List<ConnectionPool.Initializer> poolsFromConfig(Config config, PasswordSource passwordSource, Logger logger) throws InitializationException {
        Config poolsConfig;
        Map<String, JDBConnection> connectionMap = TypesafeConfig.connectionMapFromConfig(config);
        if (config.hasPath("acp.pool")) {
            poolsConfig = config.getObject("acp.pool").toConfig();
        } else if (config.hasPath("pool")) {
            poolsConfig = config.getObject("pool").toConfig();
        } else {
            throw new InitializationException("A 'pool' object must be specified");
        }
        Set<String> poolNames = TypesafeConfig.uniquePrefixSet(poolsConfig);
        if (poolNames.size() == 0) {
            throw new InitializationException("At least one pool must be specified");
        }
        ArrayList pools = Lists.newArrayListWithCapacity((int)poolNames.size());
        for (String poolName : poolNames) {
            pools.add(TypesafeConfig.poolFromConfig(poolName, poolsConfig.getObject(poolName).toConfig(), connectionMap, passwordSource, logger));
        }
        return pools;
    }

    static final ConnectionPool.Initializer poolFromConfig(String poolName, Config baseConfig, Map<String, JDBConnection> connectionMap, PasswordSource passwordSource, Logger logger) throws InitializationException {
        ConnectionPool.Initializer poolInit = new ConnectionPool.Initializer();
        poolInit.setName(poolName);
        poolInit.setLogger(logger);
        Config poolRef = ConfigFactory.load().getObject("acp.defaults.pool").toConfig();
        Config config = baseConfig.withFallback((ConfigMergeable)poolRef);
        int minActiveSegments = TypesafeConfig.getInt(config, "minActiveSegments", 1);
        poolInit.setMinActiveSegments(minActiveSegments);
        poolInit.setSaturatedAcquireTimeout(TypesafeConfig.getMilliseconds(config, "saturatedAcquireTimeout"), TimeUnit.MILLISECONDS);
        poolInit.setIdleCheckInterval(TypesafeConfig.getMilliseconds(config, "idleCheckInterval"), TimeUnit.MILLISECONDS);
        HashMap initializerMap = Maps.newHashMap();
        HashMap segmentConfigMap = Maps.newHashMap();
        ArrayList segmentNames = Lists.newArrayListWithExpectedSize((int)8);
        if (!config.hasPath("segments")) {
            segmentNames = Lists.newArrayList(TypesafeConfig.uniquePrefixSet(config));
            Collections.sort(segmentNames);
            for (String segmentName : segmentNames) {
                segmentConfigMap.put(segmentName, config.getObject(segmentName).toConfig());
            }
        } else {
            for (Object obj : config.getObjectList("segments")) {
                Config segmentConfig = obj.toConfig();
                String segmentName = TypesafeConfig.getString(segmentConfig, "name");
                segmentNames.add(segmentName);
                segmentConfigMap.put(segmentName, segmentConfig);
            }
        }
        Config segmentRef = ConfigFactory.load().getObject("acp.defaults.segment").toConfig();
        for (String segmentName : segmentNames) {
            ConnectionPoolSegment.Initializer segmentInitializer;
            Config segmentConfig = (Config)segmentConfigMap.get(segmentName);
            String cloneSegmentName = TypesafeConfig.getString(segmentConfig, "clone", "");
            ConnectionPoolSegment.Initializer baseInitializer = (ConnectionPoolSegment.Initializer)initializerMap.get(cloneSegmentName);
            if (cloneSegmentName.length() > 0 && baseInitializer == null) {
                throw new InitializationException("Forward/Invalid 'clone' reference to " + cloneSegmentName);
            }
            if (baseInitializer == null) {
                segmentConfig = segmentConfig.withFallback((ConfigMergeable)segmentRef);
                segmentInitializer = new ConnectionPoolSegment.Initializer();
            } else {
                Config cloneSegmentConfig = (Config)segmentConfigMap.get(cloneSegmentName);
                segmentConfig = segmentConfig.withFallback((ConfigMergeable)cloneSegmentConfig).withFallback((ConfigMergeable)segmentRef);
                segmentInitializer = new ConnectionPoolSegment.Initializer(baseInitializer);
            }
            segmentInitializer.setPasswordSource(passwordSource);
            segmentInitializer.setLogger(logger);
            TypesafeConfig.segmentFromConfig(poolName, segmentName, segmentConfig, segmentInitializer, connectionMap);
            segmentConfigMap.put(segmentName, segmentConfig);
            initializerMap.put(segmentName, segmentInitializer);
        }
        int startActiveSegments = TypesafeConfig.getInt(config, "startActiveSegments", 0);
        for (int i = 0; i < segmentNames.size(); ++i) {
            if (i < startActiveSegments) {
                poolInit.addActiveSegment(((ConnectionPoolSegment.Initializer)initializerMap.get(segmentNames.get(i))).createSegment());
                continue;
            }
            poolInit.addReserveSegment(((ConnectionPoolSegment.Initializer)initializerMap.get(segmentNames.get(i))).createSegment());
        }
        return poolInit;
    }

    static final ConnectionPoolSegment.Initializer segmentFromConfig(String poolName, String segmentName, Config config, ConnectionPoolSegment.Initializer initializer, Map<String, JDBConnection> connectionMap) throws InitializationException {
        initializer.setName(poolName + "." + segmentName);
        initializer.setSize(TypesafeConfig.getInt(config, "size", 1));
        initializer.setCloseConcurrency(TypesafeConfig.getInt(config, "closeConcurrency", 0));
        initializer.setTestOnLogicalOpen(TypesafeConfig.getString(config, "testOnLogicalOpen", "false").equalsIgnoreCase("true"));
        initializer.setTestOnLogicalClose(TypesafeConfig.getString(config, "testOnLogicalClose", "false").equalsIgnoreCase("true"));
        String incompleteTransactionPolicy = TypesafeConfig.getString(config, "incompleteTransactionPolicy");
        initializer.setIncompleteTransactionOnClosePolicy(ConnectionPoolConnection.IncompleteTransactionPolicy.fromString(incompleteTransactionPolicy, ConnectionPoolConnection.IncompleteTransactionPolicy.REPORT));
        String openStatementPolicy = TypesafeConfig.getString(config, "openStatementPolicy");
        initializer.setOpenStatementOnClosePolicy(ConnectionPoolConnection.OpenStatementPolicy.fromString(openStatementPolicy, ConnectionPoolConnection.OpenStatementPolicy.SILENT));
        String forceRealClosePolicy = TypesafeConfig.getString(config, "forceRealClosePolicy");
        initializer.setForceRealClosePolicy(ConnectionPoolConnection.ForceRealClosePolicy.fromString(forceRealClosePolicy, ConnectionPoolConnection.ForceRealClosePolicy.CONNECTION));
        String activityTimeoutPolicy = TypesafeConfig.getString(config, "activityTimeoutPolicy");
        initializer.setActivityTimeoutPolicy(ConnectionPoolConnection.ActivityTimeoutPolicy.fromString(activityTimeoutPolicy, ConnectionPoolConnection.ActivityTimeoutPolicy.LOG));
        initializer.setCloseTimeLimitMillis(TypesafeConfig.getMilliseconds(config, "closeTimeLimit"));
        String connectionName = TypesafeConfig.getString(config, "connectionName", "");
        JDBConnection conn = null;
        if (connectionName.length() > 0 && (conn = connectionMap.get(connectionName)) == null) {
            throw new InitializationException("No connection defined with name '" + connectionName + "'");
        }
        if (conn == null && !initializer.hasConnection()) {
            throw new InitializationException("A 'connectionName' must be specified for segment, '" + segmentName + "'");
        }
        if (conn != null) {
            initializer.setConnection(conn);
        }
        initializer.setAcquireTimeout(TypesafeConfig.getMilliseconds(config, "acquireTimeout"), TimeUnit.MILLISECONDS);
        initializer.setActiveTimeout(TypesafeConfig.getMilliseconds(config, "activeTimeout"), TimeUnit.MILLISECONDS);
        initializer.setConnectionLifetime(TypesafeConfig.getMilliseconds(config, "connectionLifetime"), TimeUnit.MILLISECONDS);
        initializer.setIdleTimeBeforeShutdown(TypesafeConfig.getMilliseconds(config, "idleTimeBeforeShutdown"), TimeUnit.MILLISECONDS);
        initializer.setMinActiveTime(TypesafeConfig.getMilliseconds(config, "minActiveTime"), TimeUnit.MILLISECONDS);
        initializer.setMaxConcurrentReconnects(TypesafeConfig.getInt(config, "reconnectConcurrency", 0));
        initializer.setMaxReconnectDelay(TypesafeConfig.getMilliseconds(config, "reconnectMaxWaitTime"), TimeUnit.MILLISECONDS);
        initializer.setActiveTimeoutMonitorFrequency(TypesafeConfig.getMilliseconds(config, "activeTimeoutMonitorFrequency"), TimeUnit.MILLISECONDS);
        return initializer;
    }

    static Map<String, JDBConnection> connectionMapFromConfig(Config config) throws InitializationException {
        Config connectionsConfig;
        Object globalPropertyConfig = config.hasPath("acp.property") ? config.getObject("acp.property").toConfig() : (config.hasPath("property") ? config.getObject("property").toConfig() : null);
        if (config.hasPath("acp.connection")) {
            connectionsConfig = config.getObject("acp.connection").toConfig();
        } else if (config.hasPath("connection")) {
            connectionsConfig = config.getObject("connection").toConfig();
        } else {
            return Collections.emptyMap();
        }
        LinkedHashMap connectionMap = Maps.newLinkedHashMap();
        for (String connectionName : TypesafeConfig.uniquePrefixSet(connectionsConfig)) {
            Config connectionConfig = connectionsConfig.getObject(connectionName).toConfig();
            connectionMap.put(connectionName, TypesafeConfig.createConnection(connectionName, connectionConfig, globalPropertyConfig));
        }
        return connectionMap;
    }

    static JDBConnection createConnection(String connectionName, Config baseConfig, Config globalPropertyConfig) throws InitializationException {
        Config connectionRef = ConfigFactory.load().getObject("acp.defaults.connection").toConfig();
        Config config = baseConfig.withFallback((ConfigMergeable)connectionRef);
        String user = TypesafeConfig.getString(config, "user");
        String password = TypesafeConfig.getString(config, "password");
        String testSQL = TypesafeConfig.getString(config, "testSQL", "");
        String connectionString = TypesafeConfig.getString(config, "connectionString");
        boolean debug = TypesafeConfig.getString(config, "debug", "false").equalsIgnoreCase("true");
        long createTimeoutMillis = TypesafeConfig.getMilliseconds(config, "createTimeout");
        long testIntervalMillis = TypesafeConfig.getMilliseconds(config, "testInterval");
        String propsRef = TypesafeConfig.getString(config, "properties", "");
        if (propsRef.length() > 0) {
            if (!globalPropertyConfig.hasPath(propsRef)) {
                throw new InitializationException("The referenced global properties, '" + propsRef + "' is not defined");
            }
            Config propsConfig = globalPropertyConfig.getObject(propsRef).toConfig();
            connectionString = TypesafeConfig.buildConnectionString(connectionString, propsConfig);
        }
        return new JDBConnection(connectionName, user, password, connectionString, createTimeoutMillis, testSQL.length() > 0 ? testSQL : null, testIntervalMillis, debug);
    }

    static void initDrivers(Config config) throws InitializationException {
        for (String driverName : TypesafeConfig.uniquePrefixSet(config)) {
            Config driverConfig = config.getObject(driverName).toConfig();
            if (driverConfig.hasPath("class")) {
                String className = driverConfig.getString("class");
                try {
                    Class.forName(className);
                    continue;
                }
                catch (Throwable t) {
                    throw new InitializationException("Unable to load JDBC driver, '" + className + "'", t);
                }
            }
            throw new InitializationException("A 'class' must be specified for JDBC driver, '" + driverName + "'");
        }
    }

    private static String buildConnectionString(String connectionString, Config config) {
        Map.Entry curr;
        if (config == null) {
            return connectionString;
        }
        StringBuilder buf = new StringBuilder();
        Iterator iter = config.entrySet().iterator();
        if (iter.hasNext()) {
            curr = (Map.Entry)iter.next();
            buf.append((String)curr.getKey()).append("=").append(((ConfigValue)curr.getValue()).unwrapped().toString());
        } else {
            return connectionString;
        }
        while (iter.hasNext()) {
            curr = (Map.Entry)iter.next();
            buf.append("&").append((String)curr.getKey()).append("=").append(((ConfigValue)curr.getValue()).unwrapped().toString());
        }
        if (connectionString.indexOf(63) > 0) {
            return connectionString + "&" + buf.toString();
        }
        return connectionString + "?" + buf.toString();
    }
}

