/*
 * Decompiled with CFR 0.152.
 */
package org.attribyte.essem.sysmon.linux;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;

public class LoadAverage
implements MetricSet,
Runnable {
    private final Gauge<Double> oneMinuteAverage = new Gauge<Double>(){

        public Double getValue() {
            return currValues.oneMinuteAverage;
        }
    };
    private final Gauge<Double> fiveMinuteAverage = new Gauge<Double>(){

        public Double getValue() {
            return currValues.fiveMinuteAverage;
        }
    };
    private final Gauge<Double> fifteenMinuteAverage = new Gauge<Double>(){

        public Double getValue() {
            return currValues.fifteenMinuteAverage;
        }
    };
    private final Gauge<Double> uptime = new Gauge<Double>(){

        public Double getValue() {
            return currValues.uptimeSeconds;
        }
    };
    private final Gauge<Double> idleTime = new Gauge<Double>(){

        public Double getValue() {
            return currValues.idleSeconds;
        }
    };
    private final ImmutableMap<String, Metric> metrics = ImmutableMap.of((Object)"load-avg-1m", this.oneMinuteAverage, (Object)"load-avg-5m", this.fiveMinuteAverage, (Object)"load-avg-15m", this.fifteenMinuteAverage, (Object)"system-uptime", this.uptime, (Object)"processor-idle-time", this.idleTime);
    private static volatile CurrentLoadValues currValues = new CurrentLoadValues();

    public LoadAverage() throws IOException {
        File loadPathFile = new File("/proc/loadavg");
        if (!loadPathFile.exists()) {
            throw new IOException("The '/proc/loadavg' does not exist");
        }
        File uptimePathFile = new File("/proc/uptime");
        if (!uptimePathFile.exists()) {
            throw new IOException("The '/proc/uptime' does not exist");
        }
    }

    @Override
    public void run() {
        currValues = new CurrentLoadValues();
    }

    public CurrentLoadValues values() {
        return new CurrentLoadValues();
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    public static class CurrentLoadValues {
        public final double oneMinuteAverage;
        public final double fiveMinuteAverage;
        public final double fifteenMinuteAverage;
        public final double uptimeSeconds;
        public final double idleSeconds;
        private static final String LOADAVG_PATH = "/proc/loadavg";
        private static final String UPTIME_PATH = "/proc/uptime";
        private static final Splitter tokenSplitter = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).trimResults().omitEmptyStrings();

        private CurrentLoadValues() {
            File loadAvgFile = new File(LOADAVG_PATH);
            if (loadAvgFile.exists()) {
                double _fifteenMinuteAverage;
                double _fiveMinuteAverage;
                double _oneMinuteAverage;
                try {
                    Iterator strValues = tokenSplitter.split((CharSequence)Files.toString((File)loadAvgFile, (Charset)Charsets.US_ASCII)).iterator();
                    _oneMinuteAverage = strValues.hasNext() ? Double.parseDouble((String)strValues.next()) : 0.0;
                    _fiveMinuteAverage = strValues.hasNext() ? Double.parseDouble((String)strValues.next()) : 0.0;
                    _fifteenMinuteAverage = strValues.hasNext() ? Double.parseDouble((String)strValues.next()) : 0.0;
                }
                catch (IOException | NumberFormatException e) {
                    _oneMinuteAverage = 0.0;
                    _fiveMinuteAverage = 0.0;
                    _fifteenMinuteAverage = 0.0;
                }
                this.oneMinuteAverage = _oneMinuteAverage;
                this.fiveMinuteAverage = _fiveMinuteAverage;
                this.fifteenMinuteAverage = _fifteenMinuteAverage;
            } else {
                this.oneMinuteAverage = 0.0;
                this.fiveMinuteAverage = 0.0;
                this.fifteenMinuteAverage = 0.0;
            }
            File uptimeFile = new File(UPTIME_PATH);
            if (uptimeFile.exists()) {
                double _idleTime;
                double _uptime;
                try {
                    Iterator strValues = tokenSplitter.split((CharSequence)Files.toString((File)uptimeFile, (Charset)Charsets.US_ASCII)).iterator();
                    _uptime = strValues.hasNext() ? Double.parseDouble((String)strValues.next()) : 0.0;
                    _idleTime = strValues.hasNext() ? Double.parseDouble((String)strValues.next()) : 0.0;
                }
                catch (IOException | NumberFormatException e) {
                    _uptime = 0.0;
                    _idleTime = 0.0;
                }
                this.uptimeSeconds = _uptime;
                this.idleSeconds = _idleTime;
            } else {
                this.uptimeSeconds = 0.0;
                this.idleSeconds = 0.0;
            }
        }

        public String toString() {
            return this.uptimeSeconds + " " + this.idleSeconds + " - " + this.oneMinuteAverage + ", " + this.fiveMinuteAverage + ", " + this.fifteenMinuteAverage;
        }
    }
}

