/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.handler.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.audit4j.core.exception.HandlerException;
import org.audit4j.handler.db.ConnectionFactory;
import org.audit4j.handler.db.DatabaseAuditHandler;

class AuditBaseDao {
    AuditBaseDao() {
    }

    protected Connection getConnection() {
        ConnectionFactory factory = ConnectionFactory.getInstance();
        return factory.getConnection();
    }

    protected String determineDatabaseType() throws HandlerException {
        String dbName = null;
        try (Connection conn = this.getConnection();){
            dbName = conn.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new HandlerException("Exception occured while getting DB Name", DatabaseAuditHandler.class, (Throwable)e);
        }
        return dbName;
    }

    protected boolean isOracleDatabase() throws HandlerException {
        String dbName = this.determineDatabaseType();
        if (dbName == null) {
            return false;
        }
        return "Oracle".equalsIgnoreCase(dbName);
    }

    protected boolean isHSQLDatabase() throws HandlerException {
        String dbName = this.determineDatabaseType();
        if (dbName == null) {
            return false;
        }
        return "HSQL Database Engine".equalsIgnoreCase(dbName);
    }

    protected boolean isMySQLDatabase() throws HandlerException {
        String dbName = this.determineDatabaseType();
        if (dbName == null) {
            return false;
        }
        return "MySQL".equalsIgnoreCase(dbName);
    }

    protected boolean isSQLServerDatabase() throws HandlerException {
        String dbName = this.determineDatabaseType();
        if (dbName == null) {
            return false;
        }
        return "Microsoft SQL Server".equalsIgnoreCase(dbName);
    }
}

