/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.handler.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.audit4j.core.dto.AuditEvent;
import org.audit4j.core.exception.HandlerException;
import org.audit4j.handler.db.AuditBaseDao;
import org.audit4j.handler.db.AuditLogDao;
import org.audit4j.handler.db.DatabaseAuditHandler;
import org.audit4j.handler.db.Utils;

final class AuditLogDaoImpl
extends AuditBaseDao
implements AuditLogDao {
    private final String tableName;
    private final String schemaName;
    private final String insertQuery;

    AuditLogDaoImpl(String tableName, String schema) throws HandlerException {
        this.tableName = Utils.checkNotEmpty(tableName, "Table name must not be empty");
        this.schemaName = schema;
        StringBuilder insertQueryBuilder = new StringBuilder();
        insertQueryBuilder.append("insert into ");
        if (!StringUtils.isEmpty((CharSequence)schema)) {
            insertQueryBuilder.append(schema).append(".");
        }
        insertQueryBuilder.append(tableName).append("(identifier, timestamp, actor, origin, action, elements) values (?, ?, ?, ?, ?, ?)");
        this.insertQuery = insertQueryBuilder.toString();
        this.createTableIfNotExists();
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean writeEvent(AuditEvent event) throws HandlerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createTableIfNotExists() throws HandlerException {
        boolean result = false;
        try (Connection conn = this.getConnection();){
            Throwable throwable;
            PreparedStatement statement;
            String tableNameWithSchema;
            StringBuilder query = new StringBuilder();
            String string = tableNameWithSchema = !StringUtils.isEmpty((CharSequence)this.schemaName) ? this.schemaName + "." + this.tableName : this.tableName;
            if (this.isOracleDatabase()) {
                query.append("select count(*) from all_tables where table_name = upper('").append(this.tableName).append("')");
                statement = conn.prepareStatement(query.toString());
                throwable = null;
                try {
                    result = statement.execute();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement != null) {
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
                if (!result) {
                    query.append("create table ").append(tableNameWithSchema).append(" (").append("identifier VARCHAR2(200) NOT NULL,").append("timestamp TIMESTAMP NOT NULL,").append("actor VARCHAR2(200) NOT NULL,").append("origin VARCHAR2(200),").append("action VARCHAR2(200) NOT NULL,").append("elements CLOB").append(");");
                }
            } else {
                if (this.isHSQLDatabase()) {
                    query.append("create table if not exists ").append(tableNameWithSchema).append(" (").append("identifier VARCHAR(200) NOT NULL,").append("timestamp TIMESTAMP NOT NULL,").append("actor VARCHAR(200) NOT NULL,").append("origin VARCHAR(200),").append("action VARCHAR(200) NOT NULL,").append("elements LONGVARCHAR").append(");");
                    statement = conn.prepareStatement(query.toString());
                    throwable = null;
                    try {
                        result = statement.execute();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (statement != null) {
                            if (throwable != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                statement.close();
                            }
                        }
                    }
                }
                if (this.isMySQLDatabase()) {
                    query.append("create table if not exists ").append(tableNameWithSchema).append(" (").append("identifier VARCHAR(200) NOT NULL,").append("timestamp TIMESTAMP NOT NULL,").append("actor VARCHAR(200) NOT NULL,").append("origin VARCHAR(200),").append("action VARCHAR(200) NOT NULL,").append("elements LONGTEXT").append(");");
                    statement = conn.prepareStatement(query.toString());
                    throwable = null;
                    try {
                        result = statement.execute();
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (statement != null) {
                            if (throwable != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                statement.close();
                            }
                        }
                    }
                }
                if (this.isSQLServerDatabase()) {
                    query.append(" IF OBJECT_ID(N'" + tableNameWithSchema + "', N'U') IS NULL BEGIN ");
                    query.append("create table ").append(tableNameWithSchema).append(" (").append("identifier VARCHAR(200) NOT NULL,").append("timestamp DATETIME NOT NULL,").append("actor VARCHAR(200) NOT NULL,").append("origin VARCHAR(200),").append("action VARCHAR(200) NOT NULL,").append("elements TEXT").append(");");
                    query.append(" END ");
                    statement = conn.prepareStatement(query.toString());
                    throwable = null;
                    try {
                        result = statement.execute();
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (statement != null) {
                            if (throwable != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                            } else {
                                statement.close();
                            }
                        }
                    }
                }
                query.append("create table if not exists ").append(tableNameWithSchema).append(" (").append("identifier VARCHAR(200) NOT NULL,").append("timestamp TIMESTAMP NOT NULL,").append("actor VARCHAR(200) NOT NULL,").append("origin VARCHAR(200),").append("action VARCHAR(200) NOT NULL,").append("elements VARCHAR(70000)").append(");");
                statement = conn.prepareStatement(query.toString());
                throwable = null;
                try {
                    result = statement.execute();
                }
                catch (Throwable throwable10) {
                    throwable = throwable10;
                    throw throwable10;
                }
                finally {
                    if (statement != null) {
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable11) {
                                throwable.addSuppressed(throwable11);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            throw new HandlerException("SQL Exception", DatabaseAuditHandler.class, (Throwable)e);
        }
    }
}

