/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.handler.db;

import org.audit4j.core.exception.InitializationException;
import org.audit4j.handler.db.EmbededDBServer;
import org.hsqldb.Server;

final class HSQLEmbededDBServer
extends EmbededDBServer {
    private static final String driver = "org.hsqldb.jdbcDriver";
    private static final String networkProtol = "jdbc:hsqldb";
    public static HSQLEmbededDBServer instance;
    private Server hsqlServer = null;

    private HSQLEmbededDBServer() {
    }

    @Override
    void start() throws InitializationException {
        if (this.hsqlServer == null) {
            this.hsqlServer = new Server();
            this.hsqlServer.setLogWriter(null);
            this.hsqlServer.setSilent(true);
            this.hsqlServer.setDatabaseName(0, "audit4j");
            this.hsqlServer.setDatabasePath(0, "file:audit4jdb;user=" + this.getUname() + ";password=" + this.getPassword());
            this.hsqlServer.start();
        }
    }

    @Override
    void shutdown() {
        this.hsqlServer.stop();
        this.hsqlServer.shutdown();
        this.hsqlServer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EmbededDBServer getInstance() {
        Class<EmbededDBServer> clazz = EmbededDBServer.class;
        synchronized (EmbededDBServer.class) {
            if (instance == null) {
                instance = new HSQLEmbededDBServer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    String getDriver() {
        return driver;
    }

    @Override
    String getNetworkProtocol() {
        return networkProtol;
    }
}

