/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.integration.spring;

import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.audit4j.core.AuditManager;
import org.audit4j.core.exception.Audit4jRuntimeException;

@Aspect
public class AuditAspect {
    @Before(value="@within(org.audit4j.core.annotation.Audit) || @annotation(org.audit4j.core.annotation.Audit)")
    public void audit(JoinPoint jointPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)jointPoint.getSignature();
        Method method = methodSignature.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = jointPoint.getTarget().getClass().getDeclaredMethod(jointPoint.getSignature().getName(), method.getParameterTypes());
            }
            catch (SecurityException exception) {
                throw new Audit4jRuntimeException("Exception occured while proceding Audit Aspect in Audit4j Spring Integration", (Throwable)exception);
            }
            catch (NoSuchMethodException exception) {
                throw new Audit4jRuntimeException("Exception occured while proceding Audit Aspect in Audit4j Spring Integration", (Throwable)exception);
            }
        }
        AuditManager.getInstance().audit(jointPoint.getTarget().getClass(), method, jointPoint.getArgs());
    }
}

