/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.integration.spring;

import java.util.List;
import java.util.Map;
import org.audit4j.core.AnnotationTransformer;
import org.audit4j.core.AuditManager;
import org.audit4j.core.Configuration;
import org.audit4j.core.MetaData;
import org.audit4j.core.filter.AuditEventFilter;
import org.audit4j.core.handler.Handler;
import org.audit4j.core.jmx.JMXConfig;
import org.audit4j.core.layout.Layout;
import org.audit4j.integration.spring.SpringSecurityWebAuditMetaData;
import org.audit4j.integration.spring.WebSessionAuditMetaData;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SpringAudit4jConfig
implements InitializingBean,
DisposableBean {
    private Layout layout;
    private List<Handler> handlers;
    private MetaData metaData;
    private List<AuditEventFilter> filters;
    private String commands;
    private JMXConfig jmx;
    private Map<String, String> properties;
    private String actorSessionAttributeName;
    private AnnotationTransformer annotationTransformer;

    public void afterPropertiesSet() throws Exception {
        Configuration configuration = Configuration.INSTANCE;
        configuration.setLayout(this.layout);
        configuration.setHandlers(this.handlers);
        configuration.setFilters(this.filters);
        configuration.setCommands(this.commands);
        configuration.setJmx(this.jmx);
        configuration.setProperties(this.properties);
        if (this.metaData == null) {
            if (this.actorSessionAttributeName == null) {
                configuration.setMetaData((MetaData)new SpringSecurityWebAuditMetaData());
            } else {
                configuration.setMetaData((MetaData)new WebSessionAuditMetaData());
            }
        } else {
            configuration.setMetaData(this.metaData);
        }
        if (this.annotationTransformer != null) {
            configuration.setAnnotationTransformer(this.annotationTransformer);
        }
        AuditManager.startWithConfiguration((Configuration)configuration);
    }

    public void destroy() throws Exception {
        AuditManager.shutdown();
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public void setFilters(List<AuditEventFilter> filters) {
        this.filters = filters;
    }

    public void setCommands(String commands) {
        this.commands = commands;
    }

    public void setJmx(JMXConfig jmx) {
        this.jmx = jmx;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setActorSessionAttributeName(String actorSessionAttributeName) {
        this.actorSessionAttributeName = actorSessionAttributeName;
    }

    public void setAnnotationTransformer(AnnotationTransformer annotationTransformer) {
        this.annotationTransformer = annotationTransformer;
    }
}

