/*
 * Decompiled with CFR 0.152.
 */
package org.audiveris.proxymusic.mxl;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.audiveris.proxymusic.mxl.RootFile;

public abstract class Mxl {
    private static final String CONTAINER_ENTRY_NAME = "META-INF/container.xml";
    private static JAXBContext containerContext;

    private Mxl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JAXBContext getContext() throws JAXBException {
        if (containerContext != null) return containerContext;
        Class<Mxl> clazz = Mxl.class;
        synchronized (Mxl.class) {
            containerContext = JAXBContext.newInstance((Class[])new Class[]{Container.class});
            // ** MonitorExit[var0] (shouldn't be in output)
            return containerContext;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlRootElement(name="container")
    private static class Container {
        @XmlElementWrapper(name="rootfiles")
        @XmlElement(name="rootfile")
        private final List<RootFile> rootFiles = new ArrayList<RootFile>();

        public void addFirstRootFile(RootFile rootFile) {
            this.rootFiles.add(0, rootFile);
        }

        public void addRootFile(RootFile rootFile) {
            this.rootFiles.add(rootFile);
        }
    }

    public static class Output {
        private final Container container = new Container();
        private final MxlOutputStream mos;
        private boolean closed;

        public Output(OutputStream out) {
            this.mos = new MxlOutputStream(new BufferedOutputStream(out));
        }

        public Output(File file) throws FileNotFoundException {
            this(new FileOutputStream(file));
        }

        public ZipEntry addEntry(RootFile rootFile) throws MxlException {
            try {
                ZipEntry entry = new ZipEntry(rootFile.fullPath);
                this.mos.putNextEntry(entry);
                this.container.addRootFile(rootFile);
                return entry;
            }
            catch (IOException ex) {
                throw new MxlException(ex);
            }
        }

        public ZipEntry addFirstEntry(RootFile rootFile) throws MxlException {
            try {
                ZipEntry entry = new ZipEntry(rootFile.fullPath);
                this.mos.putNextEntry(entry);
                this.container.addFirstRootFile(rootFile);
                return entry;
            }
            catch (IOException ex) {
                throw new MxlException(ex);
            }
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                Marshaller m = Mxl.getContext().createMarshaller();
                this.mos.putNextEntry(new ZipEntry(Mxl.CONTAINER_ENTRY_NAME));
                m.setProperty("jaxb.formatted.output", (Object)true);
                m.marshal((Object)this.container, (OutputStream)this.mos);
                this.closed = true;
                this.mos.close();
            }
            catch (JAXBException ex) {
                throw new IOException(ex);
            }
        }

        public OutputStream getOutputStream() {
            return this.mos;
        }

        public class MxlOutputStream
        extends ZipOutputStream {
            public MxlOutputStream(OutputStream out) {
                super(out, StandardCharsets.UTF_8);
            }

            @Override
            public void close() throws IOException {
                Output.this.close();
                super.close();
            }
        }
    }

    public static class MxlException
    extends Exception {
        public MxlException(Throwable cause) {
            super(cause);
        }

        public MxlException(String msg) {
            super(msg);
        }
    }

    public static class Input
    implements Closeable {
        private final ZipFile zipFile;
        private final Container container;
        private boolean closed;

        public Input(File file) throws FileNotFoundException, IOException, MxlException, JAXBException {
            this.zipFile = new ZipFile(file);
            ZipEntry containerEntry = this.zipFile.getEntry(Mxl.CONTAINER_ENTRY_NAME);
            if (containerEntry == null) {
                throw new MxlException("No container found in " + file);
            }
            InputStream cis = this.zipFile.getInputStream(containerEntry);
            Unmarshaller um = Mxl.getContext().createUnmarshaller();
            this.container = (Container)um.unmarshal(cis);
        }

        public ZipEntry getEntry(String entryName) throws IOException {
            return this.zipFile.getEntry(entryName);
        }

        public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
            return this.zipFile.getInputStream(zipEntry);
        }

        public List<RootFile> getRootFiles() {
            return Collections.unmodifiableList(this.container.rootFiles);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.zipFile.close();
            this.closed = true;
        }
    }
}

