/*
 * Decompiled with CFR 0.152.
 */
package org.audiveris.proxymusic.util;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.StreamReaderDelegate;
import org.audiveris.proxymusic.Encoding;
import org.audiveris.proxymusic.Identification;
import org.audiveris.proxymusic.ObjectFactory;
import org.audiveris.proxymusic.ScorePartwise;
import org.audiveris.proxymusic.opus.Opus;
import org.audiveris.proxymusic.util.StreamWriterDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public abstract class Marshalling {
    private static final Logger logger = LoggerFactory.getLogger(Marshalling.class);
    private static final Map<Class, JAXBContext> jaxbContextMap = new HashMap<Class, JAXBContext>();
    private static final String XML_LINE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    private static final List<String> XLINK_ATTRIBUTES = Arrays.asList("href", "type", "role", "title", "show", "actuate");
    private static final String PARTWISE_DOCTYPE_LINE = "<!DOCTYPE score-partwise PUBLIC \"-//Recordare//DTD MusicXML 4.0.2 Partwise//EN\" \"http://www.musicxml.org/dtds/partwise.dtd\">";
    private static final String OPUS_DOCTYPE_LINE = "<!DOCTYPE opus PUBLIC \"-//Recordare//DTD MusicXML 4.0.2 Opus//EN\" \"http://www.musicxml.org/dtds/opus.dtd\">";

    private Marshalling() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext getContext(Class classe) throws JAXBException {
        JAXBContext context = jaxbContextMap.get(classe);
        if (context == null) {
            Map<Class, JAXBContext> map = jaxbContextMap;
            synchronized (map) {
                context = jaxbContextMap.get(classe);
                if (context == null) {
                    context = JAXBContext.newInstance((Class[])new Class[]{classe});
                    jaxbContextMap.put(classe, context);
                }
            }
        }
        return context;
    }

    public static void marshal(ScorePartwise scorePartwise, OutputStream os, boolean injectSignature, Integer indentation) throws MarshallingException {
        try {
            Marshalling.annotate(scorePartwise, injectSignature);
            Marshaller marshaller = Marshalling.getContext(ScorePartwise.class).createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            out.write(XML_LINE);
            out.write("\n");
            out.write(PARTWISE_DOCTYPE_LINE);
            XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
            XMLStreamWriter writer = outputFactory.createXMLStreamWriter(out);
            writer = new MyStreamWriter(writer, indentation);
            marshaller.marshal((Object)scorePartwise, writer);
            writer.flush();
        }
        catch (Exception ex) {
            throw new MarshallingException(ex);
        }
    }

    public static void marshal(Opus opus, OutputStream os) throws MarshallingException {
        try {
            Marshaller marshaller = Marshalling.getContext(Opus.class).createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            out.write(XML_LINE);
            out.write("\n");
            out.write(OPUS_DOCTYPE_LINE);
            XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
            XMLStreamWriter writer = outputFactory.createXMLStreamWriter(out);
            writer = new MyStreamWriter(writer, 2);
            org.audiveris.proxymusic.opus.ObjectFactory opusFactory = new org.audiveris.proxymusic.opus.ObjectFactory();
            JAXBElement<Opus> elem = opusFactory.createOpus(opus);
            marshaller.marshal(elem, writer);
            writer.flush();
        }
        catch (Exception ex) {
            throw new MarshallingException(ex);
        }
    }

    public static void marshal(ScorePartwise scorePartwise, Node node, boolean injectSignature) throws MarshallingException {
        try {
            Marshalling.annotate(scorePartwise, injectSignature);
            Marshaller marshaller = Marshalling.getContext(ScorePartwise.class).createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal((Object)scorePartwise, node);
        }
        catch (Exception ex) {
            throw new MarshallingException(ex);
        }
    }

    public static Object unmarshal(InputStream is) throws UnmarshallingException {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            inputFactory.setProperty("javax.xml.stream.isNamespaceAware", false);
            XMLStreamReader xsr = inputFactory.createXMLStreamReader(is);
            xsr = new MyStreamReader(xsr);
            XMLEventReader reader = inputFactory.createXMLEventReader(xsr);
            while (reader.hasNext()) {
                XMLEvent event = reader.peek();
                if (event.isStartElement()) {
                    StartElement rootStart = event.asStartElement();
                    QName qName = rootStart.getName();
                    String name = qName.getLocalPart();
                    if (name.equals("opus")) {
                        Unmarshaller um = Marshalling.getContext(Opus.class).createUnmarshaller();
                        return um.unmarshal(reader, Opus.class).getValue();
                    }
                    if (name.equals("score-partwise")) {
                        Unmarshaller um = Marshalling.getContext(ScorePartwise.class).createUnmarshaller();
                        return um.unmarshal(reader, ScorePartwise.class).getValue();
                    }
                    reader.next();
                    continue;
                }
                reader.next();
            }
            return null;
        }
        catch (Exception ex) {
            throw new UnmarshallingException(ex);
        }
    }

    private static void annotate(ScorePartwise scorePartwise, boolean injectSignature) throws DatatypeConfigurationException {
        ObjectFactory factory = new ObjectFactory();
        scorePartwise.setVersion("4.0.2");
        if (injectSignature) {
            Encoding encoding;
            Identification identification = scorePartwise.getIdentification();
            if (identification == null) {
                identification = factory.createIdentification();
                scorePartwise.setIdentification(identification);
            }
            if ((encoding = identification.getEncoding()) == null) {
                encoding = factory.createEncoding();
                identification.setEncoding(encoding);
            }
            List<JAXBElement<?>> list = encoding.getEncodingDateOrEncoderOrSoftware();
            String programName = "ProxyMusic ";
            Iterator<JAXBElement<?>> it = list.iterator();
            while (it.hasNext()) {
                Object obj;
                JAXBElement<?> element = it.next();
                if (!element.getName().getLocalPart().equals("software") || !((obj = element.getValue()) instanceof String) || !((String)obj).startsWith("ProxyMusic ")) continue;
                it.remove();
                break;
            }
            list.add(factory.createEncodingSoftware("ProxyMusic 4.0.2"));
            it = list.iterator();
            while (it.hasNext()) {
                if (!it.next().getName().getLocalPart().equals("encoding-date")) continue;
                it.remove();
                break;
            }
            XMLGregorianCalendar gc = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            gc.setTimezone(Integer.MIN_VALUE);
            gc.setTime(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
            list.add(factory.createEncodingEncodingDate(gc));
        }
    }

    private static class MyStreamWriter
    extends StreamWriterDelegate {
        private final MyNamespaceContext nc = new MyNamespaceContext();
        private final String INDENT;
        private int level;
        private boolean closing;
        private PendingElement pending;

        public MyStreamWriter(XMLStreamWriter writer, Integer indentValue) throws XMLStreamException {
            super(writer);
            writer.setNamespaceContext(this.nc);
            this.INDENT = this.getIndentString(indentValue);
        }

        @Override
        public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.checkPending();
            super.writeAttribute(localName, value);
        }

        @Override
        public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
            this.checkPending();
            super.writeAttribute(namespaceURI, localName, value);
        }

        @Override
        public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
            this.checkPending();
            super.writeAttribute(prefix, namespaceURI, localName, value);
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.checkPending();
            super.writeCData(data);
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.checkPending();
            super.writeCharacters(text);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.checkPending();
            super.writeCharacters(text, start, len);
        }

        @Override
        public void writeComment(String data) throws XMLStreamException {
            this.checkPending();
            this.indentComment();
            super.writeComment(data);
        }

        @Override
        public void writeDTD(String dtd) throws XMLStreamException {
            this.checkPending();
            super.writeDTD(dtd);
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
            this.checkPending();
            super.writeDefaultNamespace(namespaceURI);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.checkPending();
            super.writeEmptyElement(localName);
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.checkPending();
            super.writeEmptyElement(namespaceURI, localName);
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.checkPending();
            super.writeEmptyElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            if (this.pending != null) {
                this.pending.writeEmpty();
                this.indentEnd();
                this.pending = null;
            } else {
                this.indentEnd();
                super.writeEndElement();
            }
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.checkPending();
            super.writeEntityRef(name);
        }

        @Override
        public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        }

        @Override
        public void writeProcessingInstruction(String target) throws XMLStreamException {
            this.checkPending();
            super.writeProcessingInstruction(target);
        }

        @Override
        public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
            this.checkPending();
            super.writeProcessingInstruction(target, data);
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.checkPending();
            this.indentStart(localName);
            this.pending = new PendingElement(localName);
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.checkPending();
            this.indentStart(localName);
            this.pending = new PendingElement2(namespaceURI, localName);
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.checkPending();
            this.indentStart(localName);
            this.pending = new PendingElement3(prefix, localName, namespaceURI);
        }

        private void checkPending() throws XMLStreamException {
            if (this.pending != null) {
                this.pending.writeStart();
                this.pending = null;
            }
        }

        private void doIndent() throws XMLStreamException {
            super.writeCharacters("\n");
            for (int i = 0; i < this.level; ++i) {
                super.writeCharacters(this.INDENT);
            }
        }

        private String getIndentString(Integer value) {
            if (value == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < value; ++i) {
                sb.append(" ");
            }
            return sb.toString();
        }

        private void indentComment() throws XMLStreamException {
            if (this.INDENT != null) {
                this.doIndent();
            }
        }

        private void indentEnd() throws XMLStreamException {
            if (this.INDENT != null) {
                --this.level;
                if (this.closing) {
                    this.doIndent();
                }
                this.closing = true;
            }
        }

        private void indentStart(String localName) throws XMLStreamException {
            if (this.INDENT != null) {
                if (localName.equals("measure")) {
                    this.doIndent();
                    super.writeComment("=======================================================");
                } else if (localName.equals("part")) {
                    this.doIndent();
                    super.writeComment("= = = = = = = = = = = = = = = = = = = = = = = = = = = = =");
                }
                this.doIndent();
                ++this.level;
                this.closing = false;
            }
        }

        private class PendingElement {
            final String localName;

            public PendingElement(String localName) {
                this.localName = localName;
            }

            public void writeEmpty() throws XMLStreamException {
                MyStreamWriter.this.getParent().writeEmptyElement(this.localName);
            }

            public void writeStart() throws XMLStreamException {
                MyStreamWriter.this.getParent().writeStartElement(this.localName);
            }
        }

        private class PendingElement2
        extends PendingElement {
            final String namespaceURI;

            public PendingElement2(String namespaceURI, String localName) {
                super(localName);
                this.namespaceURI = namespaceURI;
            }

            @Override
            public void writeEmpty() throws XMLStreamException {
                MyStreamWriter.this.getParent().writeEmptyElement(this.namespaceURI, this.localName);
            }

            @Override
            public void writeStart() throws XMLStreamException {
                MyStreamWriter.this.getParent().writeStartElement(this.namespaceURI, this.localName);
            }
        }

        private class PendingElement3
        extends PendingElement2 {
            final String prefix;

            public PendingElement3(String prefix, String localName, String namespaceURI) {
                super(namespaceURI, localName);
                this.prefix = prefix;
            }

            @Override
            public void writeEmpty() throws XMLStreamException {
                MyStreamWriter.this.getParent().writeEmptyElement(this.prefix, this.localName, this.namespaceURI);
            }

            @Override
            public void writeStart() throws XMLStreamException {
                MyStreamWriter.this.getParent().writeStartElement(this.prefix, this.localName, this.namespaceURI);
            }
        }
    }

    public static class MarshallingException
    extends Exception {
        public MarshallingException(Throwable cause) {
            super(cause);
        }
    }

    private static class MyStreamReader
    extends StreamReaderDelegate {
        public MyStreamReader(XMLStreamReader reader) {
            super(reader);
        }

        @Override
        public QName getAttributeName(int index) {
            QName qName;
            String local;
            String prefix = this.getAttributePrefix(index);
            if ("xlink".equals(prefix) && XLINK_ATTRIBUTES.contains(local = (qName = super.getAttributeName(index)).getLocalPart())) {
                return new QName(Marshalling.XLINK_NAMESPACE_URI, local, "xlink");
            }
            return super.getAttributeName(index);
        }
    }

    public static class UnmarshallingException
    extends Exception {
        public UnmarshallingException(Throwable cause) {
            super(cause);
        }
    }

    private static class MyNamespaceContext
    implements NamespaceContext {
        private String defaultNS = "";

        private MyNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if ("".equals(prefix)) {
                return this.defaultNS;
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if (Marshalling.XLINK_NAMESPACE_URI.equals(namespaceURI)) {
                return "xlink";
            }
            return "";
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }

        public void setDefaultNS(String ns) {
            this.defaultNS = ns;
        }
    }

    public static class FormattingException
    extends Exception {
        public FormattingException(Throwable cause) {
            super(cause);
        }
    }
}

