/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.graphql.geojson.scalars;

import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GeometryScalarConverter {
    public static GraphQLScalarType INSTANCE;

    static {
        Coercing<Geometry, String> coercing = new Coercing<Geometry, String>(){

            public String serialize(Object input) throws CoercingSerializeException {
                if (input instanceof Geometry) {
                    return new WKTWriter().write((Geometry)input);
                }
                throw new CoercingSerializeException("Expected a Geometry object.");
            }

            public Geometry parseValue(Object input) {
                try {
                    if (input instanceof String) {
                        return new WKTReader().read((String)input);
                    }
                    throw new CoercingParseValueException("Expected a String");
                }
                catch (ParseException ex) {
                    throw new CoercingParseValueException("Error", (Throwable)ex);
                }
            }

            public Geometry parseLiteral(Object input) {
                if (input instanceof StringValue) {
                    try {
                        return new WKTReader().read(((StringValue)input).getValue());
                    }
                    catch (ParseException ex) {
                        throw new CoercingParseValueException("Error", (Throwable)ex);
                    }
                }
                throw new CoercingParseLiteralException("Expected a StringValue.");
            }

            public Value<?> valueToLiteral(Object input) {
                String s = this.serialize(input);
                return StringValue.newStringValue((String)s).build();
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("Geometry").description("Geometry as scalar.").coercing((Coercing)coercing).build();
    }
}

