/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.graphql.pageable;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableDTO {
    private int page = 0;
    private int size = 20;
    private String[] sort;

    public Pageable toPageable() {
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        if (ArrayUtils.isNotEmpty((Object[])this.sort)) {
            for (String field : this.sort) {
                if (field == null) continue;
                String name = field.split(":")[0];
                boolean asc = field.indexOf(":") < 0 || "ASC".equalsIgnoreCase(field.split(":")[1]);
                Sort.Order o = asc ? Sort.Order.asc((String)name) : Sort.Order.desc((String)name);
                orders.add(o);
            }
        }
        if (CollectionUtils.isNotEmpty(orders)) {
            return PageRequest.of((int)this.page, (int)this.size).withSort(Sort.by(orders));
        }
        return Pageable.ofSize((int)this.size).withPage(this.page);
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public String[] getSort() {
        return this.sort;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSort(String[] sort) {
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageableDTO)) {
            return false;
        }
        PageableDTO other = (PageableDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        return Arrays.deepEquals(this.getSort(), other.getSort());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageableDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getSize();
        result = result * 59 + Arrays.deepHashCode(this.getSort());
        return result;
    }

    public String toString() {
        return "PageableDTO(page=" + this.getPage() + ", size=" + this.getSize() + ", sort=" + Arrays.deepToString(this.getSort()) + ")";
    }
}

