/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.liveness.database.probes;

import jakarta.annotation.PostConstruct;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import org.autumnframework.service.liveness.probes.LivenessProbe;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.EventListener;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnEnabledHealthIndicator(value="db")
@ConditionalOnProperty(name={"autumn.liveness.db"}, havingValue="true", matchIfMissing=true)
public class DataSourceLivenessEventListener
extends LivenessProbe {
    private final JdbcTemplate jdbcTemplate;

    public DataSourceLivenessEventListener(ApplicationEventPublisher appEventPublisher, JdbcTemplate jdbcTemplate) {
        super(appEventPublisher);
        this.jdbcTemplate = jdbcTemplate;
    }

    @PostConstruct
    public void init() {
        this.setLiveness(this.isConnectionValid(), null);
    }

    @Bean
    ConnectionEventListener datasourceConnectionEventListener() {
        return new ConnectionEventListener(){

            @Override
            @EventListener
            public void connectionClosed(ConnectionEvent event) {
                DataSourceLivenessEventListener.this.setLiveness(true, event);
            }

            @Override
            @EventListener
            public void connectionErrorOccurred(ConnectionEvent event) {
                DataSourceLivenessEventListener.this.setLiveness(DataSourceLivenessEventListener.this.isConnectionValid(), event);
            }
        };
    }

    public String getProbeTypeName() {
        return "Database connection";
    }

    private Boolean isConnectionValid() {
        return (Boolean)this.jdbcTemplate.execute(this::isConnectionValid);
    }

    private Boolean isConnectionValid(Connection connection) throws SQLException {
        return connection.isValid(0);
    }
}

