/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.pubsub.server.sender;

import java.util.UUID;

import com.fasterxml.jackson.databind.ObjectMapper;

import org.autumnframework.service.api.ServiceProperties;
import org.autumnframework.service.api.dtos.Identifiable;
import org.autumnframework.service.pubsub.api.properties.PubSubApiProperties;
import org.autumnframework.service.pubsub.server.beans.PubSubPublisherStore;
import org.autumnframework.service.queue.api.messages.IdentifiableMessage;
import org.autumnframework.service.queue.api.server.services.SenderService;
import org.autumnframework.service.validation.services.DefaultValidationService;

/**
 * @param <I>
 * @param <M>
 */
public abstract class PubSubSender< I extends Identifiable,
                                    M extends IdentifiableMessage<I>> extends GenericPubSubSender<I, M, UUID>
                                                                      implements SenderService<I, M> {

    /**
     * @param objectMapper
     * @param properties
     * @param serviceProperties
     * @param validationService
     */
    public PubSubSender(ObjectMapper objectMapper, PubSubApiProperties properties, ServiceProperties serviceProperties, DefaultValidationService validationService) {
        super(objectMapper, properties, serviceProperties,validationService);
    }

    /**
     * @param objectMapper
     * @param service
     * @param validationService
     * @param store
     */
    public PubSubSender(ObjectMapper objectMapper, String service, DefaultValidationService validationService, PubSubPublisherStore store) {
        super(objectMapper, service, validationService, store);
    }
}
