/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.queue.client.config;

import org.autumnframework.service.api.APIConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

import org.autumnframework.service.pubsub.api.properties.PubSubApiProperties;
import org.autumnframework.service.pubsub.client.PubSubClientConfig;
import org.autumnframework.service.queue.api.QueueApiProperties;
import org.autumnframework.service.rabbit.api.properties.RabbitMQApiProperties;
import org.autumnframework.service.rabbit.batch.client.config.RabbitBatchClientConfig;
import org.autumnframework.service.rabbit.client.config.RabbitClientConfig;

@Configuration
@Import(APIConfiguration.class)
@PropertySources({@PropertySource("classpath:service.properties")})
@EnableConfigurationProperties({RabbitMQApiProperties.class, PubSubApiProperties.class, QueueApiProperties.class})
public class QueueClientConfig{
    
    @Import(PubSubClientConfig.class)
    @Configuration
    @ConditionalOnProperty(havingValue = "pubsub", name = "autumn.messaging.type")
    public class PubSubClientConfigLoader {
        //
    }
    
    @Import(RabbitClientConfig.class)
    @Configuration
    @ConditionalOnExpression("'${autumn.messaging.type:rabbitmq}' == 'rabbitmq' and not ${autumn.messaging.batch-enabled:false}")
    public class RabbitClientConfigLoader {
        //
    }
    
    @Import(RabbitBatchClientConfig.class)
    @Configuration
    @ConditionalOnExpression("'${autumn.messaging.type:rabbitmq}' == 'rabbitmq' and ${autumn.messaging.batch-enabled:false}")
    @ConditionalOnProperty(havingValue = "rabbitmq", name = "org.autumnframework.messaging.type")
    public class RabbitBatchClientConfigLoader {
        //
    }
}
