/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.queue.client.config;

import org.autumnframework.service.api.APIConfiguration;
import org.autumnframework.service.pubsub.api.properties.PubSubApiProperties;
import org.autumnframework.service.pubsub.client.PubSubClientConfig;
import org.autumnframework.service.queue.api.QueueApiProperties;
import org.autumnframework.service.rabbit.api.properties.RabbitMQApiProperties;
import org.autumnframework.service.rabbit.batch.client.config.RabbitBatchClientConfig;
import org.autumnframework.service.rabbit.client.config.RabbitClientConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@Configuration
@Import(value={APIConfiguration.class})
@PropertySources(value={@PropertySource(value={"classpath:service.properties"})})
@EnableConfigurationProperties(value={RabbitMQApiProperties.class, PubSubApiProperties.class, QueueApiProperties.class})
public class QueueClientConfig {

    @Import(value={RabbitBatchClientConfig.class})
    @Configuration
    @ConditionalOnExpression(value="'${autumn.messaging.type:rabbitmq}' == 'rabbitmq' and ${autumn.messaging.batch-enabled:false}")
    @ConditionalOnProperty(havingValue="rabbitmq", name={"org.autumnframework.messaging.type"})
    public class RabbitBatchClientConfigLoader {
    }

    @Import(value={RabbitClientConfig.class})
    @Configuration
    @ConditionalOnExpression(value="'${autumn.messaging.type:rabbitmq}' == 'rabbitmq' and not ${autumn.messaging.batch-enabled:false}")
    public class RabbitClientConfigLoader {
    }

    @Import(value={PubSubClientConfig.class})
    @Configuration
    @ConditionalOnProperty(havingValue="pubsub", name={"autumn.messaging.type"})
    public class PubSubClientConfigLoader {
    }
}

