/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.rabbit.batch.client.listener;

import io.micrometer.core.annotation.Timed;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.autumnframework.service.queue.api.client.listener.batch.CrudQueueBatchListener;
import org.autumnframework.service.rabbit.client.listener.CrudMessageListenerAndDelegationService;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;

public class BatchListenerComponent {
    private final CrudMessageListenerAndDelegationService service;

    public BatchListenerComponent(CrudMessageListenerAndDelegationService service) {
        this.service = service;
    }

    @RabbitListener(queues={"${autumn.service.name}.in.create"}, containerFactory="consumerBatchContainerFactory")
    @Timed(value="autumn.messaging.rabbitmq.received.bulk.create", description="Number of bulk create messages received", extraTags={"routing-key", "create"})
    void handleCreate(List<Message> messages) {
        Collection<List<Message>> splitLists = this.splitList(messages);
        for (List<Message> list : splitLists) {
            this.service.handleList(list, (aClass, identifiableMessages) -> {
                this.service.delegateListToCrudQueueListeners(aClass, identifiableMessages, CrudQueueBatchListener::handleCreateList);
                this.service.delegateListToOnCreateListeners(aClass, identifiableMessages);
            });
        }
    }

    @RabbitListener(queues={"${autumn.service.name}.in.update"}, containerFactory="consumerBatchContainerFactory")
    @Timed(value="autumn.messaging.rabbitmq.received.bulk.update", description="Number of bulk update messages received", extraTags={"routing-key", "update"})
    void handleUpdate(List<Message> messages) {
        Collection<List<Message>> splitLists = this.splitList(messages);
        for (List<Message> list : splitLists) {
            this.service.handleList(list, (aClass, identifiableMessage) -> {
                this.service.delegateListToCrudQueueListeners(aClass, identifiableMessage, CrudQueueBatchListener::handleUpdateList);
                this.service.delegateListToOnUpdateListeners(aClass, identifiableMessage);
            });
        }
    }

    @RabbitListener(queues={"${autumn.service.name}.in.delete"}, containerFactory="consumerBatchContainerFactory")
    @Timed(value="autumn.messaging.rabbitmq.received.bulk.delete", description="Number of bulk delete messages received", extraTags={"routing-key", "delete"})
    void handleDelete(List<Message> messages) {
        Collection<List<Message>> splitLists = this.splitList(messages);
        for (List<Message> list : splitLists) {
            this.service.handleList(list, (aClass, identifiableMessages) -> {
                this.service.delegateListToCrudQueueListeners(aClass, identifiableMessages, CrudQueueBatchListener::handleDeleteList);
                this.service.delegateListToOnDeleteListeners(aClass, identifiableMessages);
            });
        }
    }

    private Collection<List<Message>> splitList(List<Message> messages) {
        return messages.stream().collect(Collectors.groupingBy(message -> message.getMessageProperties().getHeader("__TypeId__"), Collectors.toList())).values();
    }
}

