/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.test.queue.client.services;

import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.autumnframework.service.queue.api.client.listener.CrudQueueListener;
import org.autumnframework.service.queue.api.client.listener.batch.CrudQueueBatchListener;
import org.autumnframework.service.test.api.SomeDTO;
import org.autumnframework.service.test.api.SomeMessage;

/**
 * @author Timon Veenstra
 */
//@Service
@Slf4j
public class SomeMessageListenerService implements CrudQueueListener<SomeDTO, SomeMessage>, CrudQueueBatchListener<SomeDTO, SomeMessage> {
    @Override
    public void handleCreate(SomeMessage message) {
        log.trace("handleCreate some message {}",message);
        log.trace("date: {}",message.getPayload().getSomeDate());
    }

    @Override
    public void handleUpdate(SomeMessage message) {
        log.trace("handleUpdate some message {}",message);
        log.trace("date: {}",message.getPayload().getSomeDate());

    }

    @Override
    public void handleDelete(SomeMessage message) {
        log.trace("handleDelete some message {}",message);
        log.trace("date: {}",message.getPayload().getSomeDate());

    }
    
    @Override
    public void handleCreateList(List<SomeMessage> messages) {
        log.trace("handleCreateList size{}, some messages {}",messages.size(), messages);
        for (SomeMessage message : messages) {
            log.trace("date: {}",message.getPayload().getSomeDate());
        }
    }

    @Override
    public void handleUpdateList(List<SomeMessage> messages) {
        log.trace("handleUpdateList size{}, some messages {}",messages.size(), messages);
        for (SomeMessage message : messages) {
            log.trace("date: {}",message.getPayload().getSomeDate());
        }
    }

    @Override
    public void handleDeleteList(List<SomeMessage> messages) {
        log.trace("handleDeleteList size{}, some messages {}",messages.size(), messages);
        for (SomeMessage message : messages) {
            log.trace("date: {}",message.getPayload().getSomeDate());
        }
    }
}
