/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.availlang.cache.CacheException;
import org.availlang.cache.CacheInsertException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 +*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0004+,-.BI\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u001c\b\u0002\u0010\t\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\b\u0010 \u001a\u00020\u000bH\u0002J\u0006\u0010!\u001a\u00020\u000bJ\b\u0010\"\u001a\u00020\u000bH\u0002J\u0016\u0010#\u001a\u00028\u00012\u0006\u0010$\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u0004\u0018\u00018\u00012\u0006\u0010$\u001a\u00028\u0000\u00a2\u0006\u0002\u0010%J\u0015\u0010'\u001a\u0004\u0018\u00018\u00012\u0006\u0010$\u001a\u00028\u0000\u00a2\u0006\u0002\u0010%J\u001f\u0010(\u001a\u0004\u0018\u00010\u000b2\u0006\u0010$\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010*R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0014\u0012\u00120\u0011R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0016\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00120\u001dR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00120\u001fR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/availlang/cache/LRUCache;", "K", "V", "", "softCapacity", "", "strongCapacity", "transformer", "Lkotlin/Function1;", "retirementAction", "Lkotlin/Function2;", "", "(IILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "defunctReferences", "Ljava/lang/ref/ReferenceQueue;", "futures", "", "Lorg/availlang/cache/LRUCache$ValueFuture;", "futuresCondition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "keysBySoftReference", "Ljava/lang/ref/SoftReference;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "size", "getSize", "()I", "softMap", "Lorg/availlang/cache/LRUCache$SoftCacheMap;", "strongMap", "Lorg/availlang/cache/LRUCache$StrongCacheMap;", "checkInvariants", "clear", "expungeDefunctReferences", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "poll", "remove", "retire", "referent", "(Ljava/lang/Object;Ljava/lang/Object;)Lkotlin/Unit;", "Companion", "SoftCacheMap", "StrongCacheMap", "ValueFuture", "avail-storage"})
public final class LRUCache<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int softCapacity;
    private final int strongCapacity;
    @NotNull
    private final Function1<K, V> transformer;
    @Nullable
    private final Function2<K, V, Unit> retirementAction;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final ReferenceQueue<V> defunctReferences;
    @NotNull
    private final SoftCacheMap softMap;
    @NotNull
    private final Map<SoftReference<? extends V>, K> keysBySoftReference;
    @NotNull
    private final StrongCacheMap strongMap;
    @NotNull
    private final Map<K, ValueFuture> futures;
    private final Condition futuresCondition;
    @NotNull
    private static final String checkInvariantsProperty;
    private static final boolean checkInvariants;

    @JvmOverloads
    public LRUCache(int softCapacity, int strongCapacity, @NotNull Function1<? super K, ? extends V> transformer, @Nullable Function2<? super K, ? super V, Unit> retirementAction) {
        boolean bl;
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        this.softCapacity = softCapacity;
        this.strongCapacity = strongCapacity;
        this.transformer = transformer;
        this.retirementAction = retirementAction;
        this.lock = new ReentrantLock();
        this.defunctReferences = new ReferenceQueue();
        this.keysBySoftReference = new LinkedHashMap();
        this.futuresCondition = this.lock.newCondition();
        boolean bl2 = bl = this.softCapacity > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = this.strongCapacity <= this.softCapacity;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.softMap = new SoftCacheMap(this.softCapacity);
        this.strongMap = new StrongCacheMap(this.strongCapacity);
        this.futures = new LinkedHashMap();
    }

    public /* synthetic */ LRUCache(int n, int n2, Function1 function1, Function2 function2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            function2 = null;
        }
        this(n, n2, function1, function2);
    }

    private final void checkInvariants() {
        if (checkInvariants) {
            boolean bl;
            SoftReference<Object> value;
            Object key;
            boolean bl2 = this.lock.isHeldByCurrentThread();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl3 = bl2 = this.strongMap.size() <= this.strongCapacity;
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl4 = bl2 = this.softMap.size() == this.keysBySoftReference.size();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl5 = bl2 = this.softMap.size() <= this.softCapacity;
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            for (Map.Entry entry : ((Map)this.softMap).entrySet()) {
                key = entry.getKey();
                value = (SoftReference)entry.getValue();
                boolean bl6 = bl = key != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                bl = this.keysBySoftReference.containsKey(value);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                boolean bl7 = bl = this.keysBySoftReference.get(value) == key;
                if (!_Assertions.ENABLED || bl) continue;
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            for (Map.Entry entry : ((Map)this.strongMap).entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                boolean bl8 = bl = key != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                boolean bl9 = bl = value != null;
                if (!_Assertions.ENABLED || bl) continue;
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
    }

    private final void expungeDefunctReferences() {
        boolean bl = this.lock.isHeldByCurrentThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.checkInvariants();
        while (this.defunctReferences.poll() != null) {
            Reference<V> reference;
            boolean bl2;
            boolean bl3 = bl2 = reference.get() == null;
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Object key = TypeIntrinsics.asMutableMap(this.keysBySoftReference).remove(reference);
            if (key == null) continue;
            boolean bl4 = this.softMap.containsKey(key);
            if (_Assertions.ENABLED && !bl4) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.softMap.remove(key);
        }
        this.checkInvariants();
    }

    private final Unit retire(K key, V referent) {
        Unit unit;
        Function2<K, V, Unit> function2 = this.retirementAction;
        if (function2 != null) {
            function2.invoke(key, referent);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() throws InterruptedException {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.expungeDefunctReferences();
            while (!this.futures.isEmpty()) {
                this.futuresCondition.await();
            }
            Set set = this.softMap.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"softMap.entries");
            List entries2 = CollectionsKt.toList((Iterable)set);
            this.softMap.clear();
            this.keysBySoftReference.clear();
            this.strongMap.clear();
            for (Map.Entry entry : entries2) {
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entries");
                Object key = entry.getKey();
                SoftReference reference = (SoftReference)entry.getValue();
                Object referent = reference.get();
                if (referent == null) continue;
                this.retire(key, referent);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.expungeDefunctReferences();
            int n = this.softMap.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V poll(K key) {
        Lock lock = this.lock;
        lock.lock();
        try {
            Object result;
            boolean bl = false;
            this.expungeDefunctReferences();
            SoftReference softReference = (SoftReference)this.softMap.get(key);
            Object object = result = softReference != null ? softReference.get() : null;
            if (result != null) {
                ((Map)this.strongMap).put(key, result);
            }
            this.checkInvariants();
            Object t = result;
            return (V)t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) throws CacheInsertException {
        this.lock.lock();
        try {
            Object result;
            block12: {
                ValueFuture future;
                block13: {
                    SoftReference reference;
                    this.checkInvariants();
                    this.expungeDefunctReferences();
                    SoftReference softReference = reference = (SoftReference)this.softMap.get(key);
                    Object object = result = softReference != null ? softReference.get() : null;
                    if (reference != null && result != null) break block12;
                    future = this.futures.get(key);
                    if (future != null) break block13;
                    future = new ValueFuture();
                    this.futures.put(key, future);
                    this.lock.unlock();
                    RuntimeException exception = null;
                    try {
                        result = this.transformer.invoke(key);
                    }
                    catch (RuntimeException e) {
                        try {
                            exception = e;
                            this.lock.lock();
                            if (exception == null) {
                                future.setResult(result);
                            } else {
                                future.setException(exception);
                            }
                            this.futures.remove(key);
                        }
                        catch (Throwable throwable) {
                            this.lock.lock();
                            future.setResult(result);
                            this.futures.remove(key);
                            this.futuresCondition.signalAll();
                            throw throwable;
                        }
                        this.futuresCondition.signalAll();
                    }
                    this.lock.lock();
                    future.setResult(result);
                    this.futures.remove(key);
                    this.futuresCondition.signalAll();
                    Object object2 = result = future.get();
                    Intrinsics.checkNotNull(object2);
                    reference = new SoftReference(object2, this.defunctReferences);
                    ((Map)this.softMap).put(key, reference);
                    this.keysBySoftReference.put((SoftReference<K>)reference, key);
                    break block12;
                }
                this.lock.unlock();
                try {
                    result = future.get();
                }
                finally {
                    this.lock.lock();
                }
            }
            this.checkInvariants();
            Map map = this.strongMap;
            Object t = result;
            Intrinsics.checkNotNull(t);
            map.put(key, t);
            this.checkInvariants();
            Object t2 = result;
            return (V)t2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V remove(K key) {
        Lock lock = this.lock;
        lock.lock();
        try {
            Object result;
            boolean bl = false;
            this.expungeDefunctReferences();
            SoftReference reference = (SoftReference)this.softMap.remove(key);
            this.strongMap.remove(key);
            SoftReference softReference = reference;
            Object object = result = softReference != null ? softReference.get() : null;
            if (result != null) {
                this.retire(key, result);
            }
            this.checkInvariants();
            Object t = result;
            return (V)t;
        }
        finally {
            lock.unlock();
        }
    }

    @JvmOverloads
    public LRUCache(int softCapacity, int strongCapacity, @NotNull Function1<? super K, ? extends V> transformer) {
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        this(softCapacity, strongCapacity, transformer, null, 8, null);
    }

    static {
        String string = "%s.checkInvariants";
        Object[] objectArray = new Object[]{LRUCache.class.getCanonicalName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        checkInvariantsProperty = string2;
        boolean value = false;
        try {
            String property = System.getProperty(checkInvariantsProperty);
            value = Boolean.parseBoolean(property);
        }
        catch (Exception exception) {
            // empty catch block
        }
        checkInvariants = value;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010'\n\u0000\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/availlang/cache/LRUCache$StrongCacheMap;", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "capacity", "", "(Lorg/availlang/cache/LRUCache;I)V", "removeEldestEntry", "", "eldest", "", "avail-storage"})
    private final class StrongCacheMap
    extends LinkedHashMap<K, V> {
        private final int capacity;

        public StrongCacheMap(int capacity) {
            super(capacity, 0.75f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(@Nullable Map.Entry<K, V> eldest) {
            return this.size() > this.capacity;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010'\n\u0000\b\u0080\u0004\u0018\u00002*\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00020\u0001j\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0002`\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u00020\b2\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0002\u0018\u00010\nH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/availlang/cache/LRUCache$SoftCacheMap;", "Ljava/util/LinkedHashMap;", "Ljava/lang/ref/SoftReference;", "Lkotlin/collections/LinkedHashMap;", "capacity", "", "(Lorg/availlang/cache/LRUCache;I)V", "removeEldestEntry", "", "eldest", "", "avail-storage"})
    public final class SoftCacheMap
    extends LinkedHashMap<K, SoftReference<V>> {
        private final int capacity;

        public SoftCacheMap(int capacity) {
            super(capacity, 0.75f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(@Nullable Map.Entry<K, SoftReference<V>> eldest) {
            boolean bl = LRUCache.this.lock.isHeldByCurrentThread();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl2 = bl = this == LRUCache.this.softMap;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.size() > this.capacity) {
                boolean bl3 = bl = eldest != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                Map.Entry entry = eldest;
                Intrinsics.checkNotNull(entry);
                Object key = entry.getKey();
                SoftReference reference = eldest.getValue();
                boolean bl4 = LRUCache.this.softMap.containsKey(key);
                if (_Assertions.ENABLED && !bl4) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                bl4 = LRUCache.this.keysBySoftReference.containsKey(reference);
                if (_Assertions.ENABLED && !bl4) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                LRUCache.this.softMap.remove(key);
                LRUCache.this.keysBySoftReference.remove(reference);
                Object referent = reference.get();
                if (referent != null) {
                    LRUCache.this.retire(key, referent);
                }
            }
            return false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00010\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u000f\u0010\u0019\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0019\u001a\u00028\u00012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0010H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n2\u000e\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u0004\u0018\u00018\u00012\b\u0010\u0011\u001a\u0004\u0018\u00018\u0001@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/availlang/cache/LRUCache$ValueFuture;", "Ljava/util/concurrent/Future;", "(Lorg/availlang/cache/LRUCache;)V", "completionCondition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "computationLock", "Ljava/util/concurrent/locks/ReentrantLock;", "exception", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "getException", "()Ljava/lang/RuntimeException;", "setException", "(Ljava/lang/RuntimeException;)V", "isDone", "", "result", "getResult", "()Ljava/lang/Object;", "setResult", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "cancel", "mayInterruptIfRunning", "get", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "isCancelled", "avail-storage"})
    private final class ValueFuture
    implements Future<V> {
        @NotNull
        private final ReentrantLock computationLock = new ReentrantLock();
        private final Condition completionCondition = this.computationLock.newCondition();
        private volatile boolean isDone;
        @Nullable
        private V result;
        @Nullable
        private volatile RuntimeException exception;

        @Nullable
        public final V getResult() {
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setResult(@Nullable V result) {
            Lock lock = this.computationLock;
            lock.lock();
            try {
                boolean bl = false;
                this.result = result;
                this.isDone = true;
                this.completionCondition.signalAll();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        @Nullable
        public final RuntimeException getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setException(@Nullable RuntimeException exception) {
            Lock lock = this.computationLock;
            lock.lock();
            try {
                boolean bl = false;
                this.exception = exception;
                this.isDone = true;
                this.completionCondition.signalAll();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public V get() throws CacheException {
            RuntimeException ex;
            if (!this.isDone) {
                Lock lock = this.computationLock;
                lock.lock();
                try {
                    boolean bl = false;
                    while (!this.isDone) {
                        this.completionCondition.await();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
            if ((ex = this.exception) != null) {
                throw new CacheInsertException(ex);
            }
            return this.result;
        }

        @Override
        public V get(long timeout, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/availlang/cache/LRUCache$Companion;", "", "()V", "checkInvariants", "", "checkInvariantsProperty", "", "avail-storage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

