/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.persistence;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.cache.LRUCache;
import org.availlang.persistence.IndexedFileException;
import org.availlang.persistence.IndexedFileKt;
import org.availlang.persistence.MalformedSerialStreamException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 `2\u00020\u0001:\u0004_`abB\u0084\u0001\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0019\u0010\n\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\b\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u000f\u0012\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u0015\u00a2\u0006\u0002\u0010\u0016J\u0012\u00108\u001a\u00020%2\b\b\u0002\u00109\u001a\u00020\tH\u0002J\"\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u00020\u00072\b\b\u0002\u0010<\u001a\u00020\u000f2\b\b\u0002\u0010=\u001a\u00020\u000fJ\u0018\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u000fH\u0002J\u0010\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020\u0007H\u0002J\u0010\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\u0007H\u0002J\u0010\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u0019H\u0002J\u0006\u0010H\u001a\u00020\fJ\u0006\u0010I\u001a\u00020\fJ\b\u0010J\u001a\u00020\fH\u0002J\u0016\u0010K\u001a\b\u0018\u00010'R\u00020\u00002\u0006\u0010L\u001a\u00020\u0019H\u0002J\u0010\u0010M\u001a\u00020\u00192\u0006\u0010N\u001a\u00020\u000fH\u0002J\u0015\u0010O\u001a\u00020\u00072\u0006\u0010P\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\bQJ\u0018\u0010R\u001a\u00020\f2\u0006\u0010C\u001a\u00020\u00072\u0006\u0010P\u001a\u00020\u0019H\u0002J\u0011\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020\u0019H\u0086\u0002J\"\u0010U\u001a\u00020\f2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u0015H\u0002J \u0010V\u001a\u00020\u00072\u0006\u0010W\u001a\u00020\u00192\u0006\u0010X\u001a\u00020@2\u0006\u0010Y\u001a\u00020\u000fH\u0002J\u0006\u0010Z\u001a\u00020\fJ!\u0010[\u001a\u00020\f2\u0017\u0010\\\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\rH\u0002J\b\u0010]\u001a\u00020^H\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00070\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0018\u00010'R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010 R\u000e\u0010,\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010.\u001a\u0004\u0018\u00010\u00072\b\u0010-\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0010\u00103\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lorg/availlang/persistence/IndexedFile;", "", "fileReference", "Ljava/io/File;", "file", "Ljava/io/RandomAccessFile;", "headerBytes", "", "forWriting", "", "setupActionIfNew", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "softCacheSize", "", "strongCacheSize", "pageSize", "compressionBlockSize", "version", "versionCheck", "Lkotlin/Function2;", "(Ljava/io/File;Ljava/io/RandomAccessFile;[BZLkotlin/jvm/functions/Function1;IIIIILkotlin/jvm/functions/Function2;)V", "blockCache", "Lorg/availlang/cache/LRUCache;", "", "channel", "Ljava/nio/channels/FileChannel;", "getChannel", "()Ljava/nio/channels/FileChannel;", "defaultFanout", "getDefaultFanout", "()I", "fanout", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "longTermWriterLock", "Ljava/nio/channels/FileLock;", "master", "Lorg/availlang/persistence/IndexedFile$MasterNode;", "masterNodeBuffer", "Ljava/nio/ByteBuffer;", "masterNodeSize", "getMasterNodeSize$avail_storage", "masterPosition", "newMetadata", "metadata", "getMetadata", "()[B", "setMetadata", "([B)V", "metadataCache", "previousMasterPosition", "size", "getSize", "()J", "acquireLockForWriting", "wait", "add", "record", "start", "length", "addOrphan", "orphanLocation", "Lorg/availlang/persistence/IndexedFile$RecordCoordinates;", "level", "appendRawBytes", "bytes", "appendSizedBytes", "compressedBytes", "blockAtFilePosition", "filePosition", "close", "commit", "compressAndFlushIfFull", "decodeMasterNode", "nodePosition", "fanoutRaisedTo", "exponent", "fetchSizedFromFile", "startFilePosition", "fetchSizedFromFile$avail_storage", "fillBuffer", "get", "index", "readHeaderData", "recordAtZeroBasedIndex", "startingIndex", "startingNodePosition", "startingLevel", "refresh", "setUpNewFile", "action", "toString", "", "ByteArrayOutputStream", "Companion", "MasterNode", "RecordCoordinates", "avail-storage"})
public final class IndexedFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File fileReference;
    @NotNull
    private RandomAccessFile file;
    @NotNull
    private final byte[] headerBytes;
    private final boolean forWriting;
    private int pageSize;
    private int compressionBlockSize;
    private int version;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @Nullable
    private FileLock longTermWriterLock;
    private int fanout;
    @Nullable
    private MasterNode master;
    @NotNull
    private ByteBuffer masterNodeBuffer;
    private long masterPosition;
    private long previousMasterPosition;
    @NotNull
    private final LRUCache<Long, byte[]> blockCache;
    @Nullable
    private volatile byte[] metadataCache;

    public IndexedFile(@NotNull File fileReference, @NotNull RandomAccessFile file, @NotNull byte[] headerBytes, boolean forWriting, @Nullable Function1<? super IndexedFile, Unit> setupActionIfNew, int softCacheSize, int strongCacheSize, int pageSize, int compressionBlockSize, int version, @NotNull Function2<? super Integer, ? super Integer, Boolean> versionCheck) {
        Intrinsics.checkNotNullParameter((Object)fileReference, (String)"fileReference");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)headerBytes, (String)"headerBytes");
        Intrinsics.checkNotNullParameter(versionCheck, (String)"versionCheck");
        this.fileReference = fileReference;
        this.file = file;
        this.headerBytes = headerBytes;
        this.forWriting = forWriting;
        this.pageSize = pageSize;
        this.compressionBlockSize = compressionBlockSize;
        this.version = version;
        this.lock = new ReentrantReadWriteLock();
        this.fanout = this.getDefaultFanout();
        this.blockCache = new LRUCache(softCacheSize, strongCacheSize, (Function1)new Function1<Long, byte[]>(this){
            final /* synthetic */ IndexedFile this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final byte[] invoke(long blockPosition) {
                byte[] byArray;
                try {
                    boolean bl;
                    byte[] block = this.this$0.fetchSizedFromFile$avail_storage(blockPosition);
                    Inflater inflater = new Inflater();
                    inflater.setInput(block);
                    List buffers = new ArrayList<E>();
                    int size = 0;
                    int bufferPos = -1;
                    while (!inflater.needsInput()) {
                        byte[] buffer = new byte[IndexedFile.access$getCompressionBlockSize$p(this.this$0) * 3 >> 1];
                        bufferPos = inflater.inflate(buffer);
                        size += bufferPos;
                        buffers.add(buffer);
                    }
                    ByteBuffer inflated = ByteBuffer.wrap(new byte[size]);
                    int n = buffers.size() - 1;
                    for (int i = 0; i < n; ++i) {
                        inflated.put((byte[])buffers.get(i));
                    }
                    inflated.put((byte[])buffers.get(buffers.size() - 1), 0, bufferPos);
                    boolean bl2 = bl = inflated.position() == inflated.capacity();
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    byArray = inflated.array();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                byte[] byArray2 = byArray;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"try\n\t\t\t{\n\t\t\t\tval block =\u2026 RuntimeException(e)\n\t\t\t}");
                return byArray2;
            }
        }, null, 8, null);
        if (setupActionIfNew == null) {
            this.readHeaderData(versionCheck);
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.getMasterNodeSize$avail_storage());
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(masterNodeSize)");
            this.masterNodeBuffer = byteBuffer;
            this.refresh();
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.getMasterNodeSize$avail_storage());
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(masterNodeSize)");
            this.masterNodeBuffer = byteBuffer;
            this.setUpNewFile(setupActionIfNew);
        }
    }

    private final int getDefaultFanout() {
        return 32;
    }

    private final FileChannel getChannel() {
        FileChannel fileChannel = this.file.getChannel();
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"file.channel");
        return fileChannel;
    }

    public final int getMasterNodeSize$avail_storage() {
        return (this.pageSize << 1) + this.compressionBlockSize;
    }

    private final FileLock acquireLockForWriting(boolean wait) throws IOException {
        FileLock fileLock;
        if (wait) {
            FileLock fileLock2 = this.getChannel().lock(0x7FFFFFFFFFFFFFFEL, 1L, false);
            fileLock = fileLock2;
            Intrinsics.checkNotNullExpressionValue((Object)fileLock2, (String)"channel.lock(0x7FFFFFFFFFFFFFFEL, 1, false)");
        } else {
            FileLock fileLock3 = this.getChannel().tryLock(0x7FFFFFFFFFFFFFFEL, 1L, false);
            fileLock = fileLock3;
            Intrinsics.checkNotNullExpressionValue((Object)fileLock3, (String)"channel.tryLock(0x7FFFFFFFFFFFFFFEL, 1, false)");
        }
        return fileLock;
    }

    static /* synthetic */ FileLock acquireLockForWriting$default(IndexedFile indexedFile, boolean bl, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = true;
        }
        return indexedFile.acquireLockForWriting(bl);
    }

    private final void addOrphan(RecordCoordinates orphanLocation, int level) throws IOException {
        MasterNode masterNode = this.master;
        Intrinsics.checkNotNull((Object)masterNode);
        MasterNode m = masterNode;
        if (level >= m.getOrphansByLevel().size()) {
            m.getOrphansByLevel().add(new ArrayList());
        }
        List<RecordCoordinates> orphans = m.getOrphansByLevel().get(level);
        orphans.add(orphanLocation);
        if (orphans.size() == this.fanout) {
            RecordCoordinates newOrphanLocation = new RecordCoordinates(m.getFileLimit(), m.getRawBytes().size());
            for (RecordCoordinates orphan : orphans) {
                m.getUncompressedData().writeLong(orphan.getFilePosition());
                m.getUncompressedData().writeInt(orphan.getBlockPosition());
            }
            orphans.clear();
            this.compressAndFlushIfFull();
            this.addOrphan(newOrphanLocation, level + 1);
        }
    }

    private final void appendRawBytes(byte[] bytes) throws IOException {
        MasterNode masterNode = this.master;
        Intrinsics.checkNotNull((Object)masterNode);
        MasterNode m = masterNode;
        int bufferPos = (int)m.getFileLimit() % this.pageSize;
        int start = 0;
        int end = bytes.length;
        while (start < end) {
            boolean bl;
            int limit = Math.min(bufferPos + end - start, m.getLastPartialBuffer().length);
            int count = limit - bufferPos;
            boolean bl2 = bl = count > 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Previous write should have flushed the buffer.";
                throw new AssertionError((Object)string);
            }
            System.arraycopy(bytes, start, m.getLastPartialBuffer(), bufferPos, count);
            start += count;
            if ((bufferPos += count) >= this.pageSize) {
                boolean bl4 = bl = bufferPos == this.pageSize;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                FileChannel c = this.getChannel();
                c.position(m.getFileLimit() / (long)this.pageSize * (long)this.pageSize);
                c.write(ByteBuffer.wrap(m.getLastPartialBuffer()));
                bufferPos = 0;
            }
            m.setFileLimit(m.getFileLimit() + (long)count);
        }
    }

    private final void appendSizedBytes(byte[] compressedBytes) throws IOException {
        byte[] sizePrefix = new byte[]{(byte)(compressedBytes.length >> 24), (byte)(compressedBytes.length >> 16 & 0xFF), (byte)(compressedBytes.length >> 8 & 0xFF), (byte)(compressedBytes.length & 0xFF)};
        this.appendRawBytes(sizePrefix);
        this.appendRawBytes(compressedBytes);
    }

    private final byte[] blockAtFilePosition(long filePosition) {
        MasterNode masterNode = this.master;
        Intrinsics.checkNotNull((Object)masterNode);
        MasterNode m = masterNode;
        return filePosition == m.getFileLimit() ? m.getRawBytes().getUnsafeBytes() : this.blockCache.get(filePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void compressAndFlushIfFull() throws IOException {
        MasterNode masterNode = this.master;
        Intrinsics.checkNotNull((Object)masterNode);
        MasterNode m = masterNode;
        if (m.getRawBytes().size() >= this.compressionBlockSize) {
            ByteArrayOutputStream compressedStream = new ByteArrayOutputStream(this.compressionBlockSize);
            Closeable closeable = new DeflaterOutputStream((OutputStream)compressedStream, new Deflater(9));
            Throwable throwable = null;
            try {
                DeflaterOutputStream it = (DeflaterOutputStream)closeable;
                boolean bl = false;
                it.write(m.getRawBytes().getUnsafeBytes(), 0, m.getRawBytes().size());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            while (m.getFileLimit() + (long)4 + (long)compressedStream.size() >= this.file.length()) {
                this.getChannel().position(0L);
                long delta = (Math.min(m.getFileLimit(), 0x500000L) + (long)this.pageSize - 1L) / (long)this.pageSize * (long)this.pageSize;
                this.file.setLength(this.file.length() + delta);
            }
            byte[] byArray = compressedStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"compressedStream.toByteArray()");
            this.appendSizedBytes(byArray);
            m.getRawBytes().reset();
        }
    }

    private final void setUpNewFile(Function1<? super IndexedFile, Unit> action) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        byte[] headerBytes = this.headerBytes;
        this.previousMasterPosition = ((long)headerBytes.length + 16L + (long)this.pageSize - 1L) / (long)this.pageSize * (long)this.pageSize;
        this.masterPosition = this.previousMasterPosition + (long)this.getMasterNodeSize$avail_storage();
        long fileLimit = this.masterPosition + (long)this.getMasterNodeSize$avail_storage();
        long bufferSize = this.previousMasterPosition + (long)this.getMasterNodeSize$avail_storage() << 1;
        boolean bl4 = bl3 = bufferSize == (long)((int)bufferSize);
        if (_Assertions.ENABLED && !bl3) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)bufferSize);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put(headerBytes);
        buffer.putInt(this.version);
        buffer.putInt(this.pageSize);
        buffer.putInt(this.compressionBlockSize);
        buffer.putInt(this.fanout);
        buffer.put(new byte[(int)this.previousMasterPosition - buffer.position()]);
        boolean bl5 = bl2 = (long)buffer.position() == this.previousMasterPosition;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        MasterNode m = new MasterNode(1, fileLimit);
        ByteBuffer b = this.masterNodeBuffer;
        m.writeTo(b);
        buffer.put(b);
        boolean bl6 = bl = (long)buffer.position() == this.masterPosition;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        m = new MasterNode(2, fileLimit);
        m.writeTo(b);
        buffer.put(b);
        boolean bl7 = bl = (long)buffer.position() == fileLimit;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        buffer.rewind();
        this.master = m;
        try {
            boolean bl8;
            File tempFilename = File.createTempFile("new indexed file", null, this.fileReference.getParentFile());
            tempFilename.deleteOnExit();
            RandomAccessFile tempExistingSpuriousFile = this.file;
            this.file = new RandomAccessFile(tempFilename, "rw");
            boolean bl9 = bl8 = this.file.length() == 0L;
            if (_Assertions.ENABLED && !bl8) {
                boolean bl10 = false;
                String string = "The file is not empty.";
                throw new AssertionError((Object)string);
            }
            this.file.setLength((long)this.pageSize * 100L);
            this.longTermWriterLock = IndexedFile.acquireLockForWriting$default(this, false, 1, null);
            this.getChannel().write(buffer);
            this.getChannel().force(true);
            action.invoke((Object)this);
            FileLock fileLock = this.longTermWriterLock;
            if (fileLock != null) {
                fileLock.close();
            }
            this.longTermWriterLock = null;
            this.getChannel().close();
            tempExistingSpuriousFile.close();
            if (!tempFilename.renameTo(this.fileReference)) {
                this.fileReference.delete();
                if (!tempFilename.renameTo(this.fileReference)) {
                    throw new IOException("rename failed");
                }
            }
            this.file = new RandomAccessFile(this.fileReference, "rw");
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private final MasterNode decodeMasterNode(long nodePosition) throws IOException {
        boolean bl;
        boolean $i$a$-assert-IndexedFile$decodeMasterNode$22;
        int left;
        this.getChannel().position(nodePosition);
        ByteBuffer b = this.masterNodeBuffer;
        b.rewind();
        this.getChannel().read(b);
        CRC32 encoder = new CRC32();
        encoder.update(b.array(), 4, b.position() - 4);
        b.rewind();
        if (b.getInt() != (int)encoder.getValue()) {
            return null;
        }
        MasterNode node = new MasterNode(b.getInt(), b.getLong());
        int compressionBlockPosition = b.getInt();
        node.setMetadataLocation(new RecordCoordinates(b.getLong(), b.getInt()));
        List orphans = new ArrayList();
        for (left = b.getInt(); 0 < left; --left) {
            int level = b.get() - 1;
            RecordCoordinates orphan = new RecordCoordinates(b.getLong(), b.getInt());
            while (level >= orphans.size()) {
                orphans.add((List)new ArrayList());
            }
            ((List)orphans.get(level)).add(orphan);
        }
        int n = left = b.position() <= this.pageSize ? 1 : 0;
        if (_Assertions.ENABLED && left == 0) {
            $i$a$-assert-IndexedFile$decodeMasterNode$22 = false;
            String $i$a$-assert-IndexedFile$decodeMasterNode$22 = "Too much index orphan information for a page.";
            throw new AssertionError((Object)$i$a$-assert-IndexedFile$decodeMasterNode$22);
        }
        node.getOrphansByLevel().clear();
        node.getOrphansByLevel().addAll(orphans);
        b.position(this.pageSize);
        byte[] lastPageContents = new byte[this.pageSize];
        b.get(lastPageContents);
        boolean bl2 = $i$a$-assert-IndexedFile$decodeMasterNode$22 = b.position() == this.pageSize << 1;
        if (_Assertions.ENABLED && !$i$a$-assert-IndexedFile$decodeMasterNode$22) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        node.setLastPartialBuffer(lastPageContents);
        byte[] uncompressed = new byte[this.compressionBlockSize];
        b.get(uncompressed);
        boolean bl3 = bl = b.position() == b.capacity();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl4 = bl = b.position() == this.getMasterNodeSize$avail_storage();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        node.getRawBytes().reset();
        node.getUncompressedData().write(uncompressed, 0, compressionBlockPosition);
        return node;
    }

    @NotNull
    public final byte[] fetchSizedFromFile$avail_storage(long startFilePosition) throws IOException {
        byte[] sizePrefix = new byte[4];
        this.fillBuffer(sizePrefix, startFilePosition);
        int size = (sizePrefix[0] & 0xFF) << 24 | (sizePrefix[1] & 0xFF) << 16 | (sizePrefix[2] & 0xFF) << 8 | sizePrefix[3] & 0xFF;
        byte[] content = new byte[size];
        this.fillBuffer(content, startFilePosition + (long)4);
        return content;
    }

    private final void fillBuffer(byte[] bytes, long startFilePosition) throws IOException {
        boolean bl;
        MasterNode masterNode = this.master;
        Intrinsics.checkNotNull((Object)masterNode);
        MasterNode m = masterNode;
        long writtenLimit = m.getFileLimit() / (long)this.pageSize * (long)this.pageSize;
        long endFilePosition = startFilePosition + (long)bytes.length;
        boolean bl2 = bl = endFilePosition <= m.getFileLimit();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (startFilePosition < writtenLimit) {
            this.getChannel().position(startFilePosition);
            if (endFilePosition <= writtenLimit) {
                boolean bl3;
                int bytesRead = this.getChannel().read(ByteBuffer.wrap(bytes));
                boolean bl4 = bl3 = bytesRead == bytes.length;
                if (_Assertions.ENABLED && !bl3) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            } else {
                boolean bl5;
                int split = (int)(writtenLimit - startFilePosition);
                int bytesRead = this.getChannel().read(ByteBuffer.wrap(bytes, 0, split));
                boolean bl6 = bl5 = bytesRead == split;
                if (_Assertions.ENABLED && !bl5) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                System.arraycopy(m.getLastPartialBuffer(), 0, bytes, split, bytes.length - split);
            }
        } else {
            boolean bl7;
            long startInLastPartialBuffer = startFilePosition - writtenLimit;
            boolean bl8 = bl7 = startInLastPartialBuffer == (long)((int)startInLastPartialBuffer);
            if (_Assertions.ENABLED && !bl7) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl9 = bl7 = startInLastPartialBuffer + (long)bytes.length <= (long)m.getLastPartialBuffer().length;
            if (_Assertions.ENABLED && !bl7) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            System.arraycopy(m.getLastPartialBuffer(), (int)startInLastPartialBuffer, bytes, 0, bytes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readHeaderData(Function2<? super Integer, ? super Integer, Boolean> versionCheck) throws IOException, IndexedFileException {
        boolean finished = false;
        try {
            boolean bl;
            boolean bl2 = bl = this.file.length() > 0L;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int bufferSize = this.headerBytes.length + 16;
            ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
            this.getChannel().read(buffer);
            byte[] foundHeader = new byte[this.headerBytes.length];
            buffer.rewind();
            buffer.get(foundHeader);
            if (!Arrays.equals(foundHeader, this.headerBytes)) {
                throw new IndexedFileException("indexed file header is not valid.");
            }
            int foundVersion = buffer.getInt();
            if (!((Boolean)versionCheck.invoke((Object)foundVersion, (Object)this.version)).booleanValue()) {
                throw new IndexedFileException("Unsupported indexed file version: " + foundVersion);
            }
            this.pageSize = buffer.getInt();
            this.compressionBlockSize = buffer.getInt();
            this.fanout = buffer.getInt();
            this.previousMasterPosition = ((long)bufferSize + (long)this.pageSize - 1L) / (long)this.pageSize * (long)this.pageSize;
            this.masterPosition = this.previousMasterPosition + (long)this.getMasterNodeSize$avail_storage();
            finished = true;
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
    }

    private final long fanoutRaisedTo(int exponent) {
        long value = 0L;
        value = 1L;
        int n = 0;
        while (n < exponent) {
            int it = n++;
            boolean bl = false;
            value *= (long)this.fanout;
        }
        return value;
    }

    private final byte[] recordAtZeroBasedIndex(long startingIndex, RecordCoordinates startingNodePosition, int startingLevel) {
        boolean bl;
        long power = this.fanoutRaisedTo(startingLevel);
        boolean bl2 = bl = startingIndex < power;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-IndexedFile$recordAtZeroBasedIndex$22 = false;
            String $i$a$-assert-IndexedFile$recordAtZeroBasedIndex$22 = "Arithmetic error traversing perfect tree";
            throw new AssertionError((Object)$i$a$-assert-IndexedFile$recordAtZeroBasedIndex$22);
        }
        RecordCoordinates node = new RecordCoordinates(startingNodePosition.getFilePosition(), startingNodePosition.getBlockPosition());
        ByteBuffer buffer = ByteBuffer.wrap(this.blockAtFilePosition(node.getFilePosition()));
        buffer.position(node.getBlockPosition());
        long zIndex = startingIndex;
        for (int level = startingLevel; level != 0; --level) {
            int zSubscript = (int)(zIndex / (power /= (long)this.fanout));
            zIndex %= power;
            buffer.position(12 * zSubscript + node.getBlockPosition());
            node = new RecordCoordinates(buffer.getLong(), buffer.getInt());
            buffer = ByteBuffer.wrap(this.blockAtFilePosition(node.getFilePosition()));
            buffer.position(node.getBlockPosition());
        }
        byte[] result = new byte[buffer.getInt()];
        buffer.get(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long add(@NotNull byte[] record, int start, int length) throws IndexOutOfBoundsException, IndexedFileException {
        long l;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        boolean bl = this.forWriting;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ReentrantReadWriteLock $this$safeWrite$iv = this.lock;
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl2 = false;
            try {
                FileLock fileLock = this.longTermWriterLock;
                if (fileLock == null) {
                    IndexedFile $this$add_u24lambda_u2d7_u24lambda_u2d6 = this;
                    boolean bl3 = false;
                    $this$add_u24lambda_u2d7_u24lambda_u2d6.longTermWriterLock = IndexedFile.acquireLockForWriting$default($this$add_u24lambda_u2d7_u24lambda_u2d6, false, 1, null);
                    $this$add_u24lambda_u2d7_u24lambda_u2d6.refresh();
                    fileLock = Unit.INSTANCE;
                }
                MasterNode masterNode = this.master;
                Intrinsics.checkNotNull((Object)masterNode);
                MasterNode m = masterNode;
                RecordCoordinates coordinates = new RecordCoordinates(m.getFileLimit(), m.getRawBytes().size());
                m.getUncompressedData().writeInt(length);
                m.getUncompressedData().write(record, start, length);
                this.compressAndFlushIfFull();
                this.addOrphan(coordinates, 0);
            }
            catch (IOException e) {
                throw new IndexedFileException(e);
            }
            l = this.getSize() - 1L;
        }
        finally {
            lock.unlock();
        }
        return l;
    }

    public static /* synthetic */ long add$default(IndexedFile indexedFile, byte[] byArray, int n, int n2, int n3, Object object) throws IndexOutOfBoundsException, IndexedFileException {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return indexedFile.add(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        ReentrantReadWriteLock $this$safeWrite$iv = this.lock;
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            FileLock fileLock = this.longTermWriterLock;
            if (fileLock != null) {
                FileLock it = fileLock;
                boolean bl2 = false;
                IndexedFileKt.close(it);
                this.longTermWriterLock = null;
            }
            IndexedFileKt.close(this.getChannel());
            IndexedFileKt.close(this.file);
            try {
                this.blockCache.clear();
            }
            catch (InterruptedException interruptedException) {
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() throws IOException {
        boolean bl = this.forWriting;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ReentrantReadWriteLock $this$safeWrite$iv = this.lock;
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl2 = false;
            FileLock fileLock = this.longTermWriterLock;
            if (fileLock == null) {
                IndexedFile $this$commit_u24lambda_u2d12_u24lambda_u2d10 = this;
                boolean bl3 = false;
                $this$commit_u24lambda_u2d12_u24lambda_u2d10.longTermWriterLock = IndexedFile.acquireLockForWriting$default($this$commit_u24lambda_u2d12_u24lambda_u2d10, false, 1, null);
                $this$commit_u24lambda_u2d12_u24lambda_u2d10.refresh();
                fileLock = Unit.INSTANCE;
            }
            try {
                MasterNode masterNode = this.master;
                Intrinsics.checkNotNull((Object)masterNode);
                MasterNode m = masterNode;
                FileChannel c = this.getChannel();
                ByteBuffer b = this.masterNodeBuffer;
                c.force(true);
                long exchange = this.masterPosition;
                this.masterPosition = this.previousMasterPosition;
                this.previousMasterPosition = exchange;
                int n = m.getSerialNumber();
                m.setSerialNumber(n + 1);
                m.writeTo(b);
                FileLock shortTermLock = c.lock(this.pageSize, (long)this.getMasterNodeSize$avail_storage() << 1, false);
                try {
                    c.position(this.masterPosition);
                    c.write(b);
                    c.force(true);
                }
                finally {
                    Intrinsics.checkNotNullExpressionValue((Object)shortTermLock, (String)"shortTermLock");
                    IndexedFileKt.close(shortTermLock);
                }
            }
            finally {
                FileLock fileLock2 = this.longTermWriterLock;
                if (fileLock2 != null) {
                    FileLock it = fileLock2;
                    boolean bl4 = false;
                    IndexedFileKt.close(it);
                    this.longTermWriterLock = null;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] get(long index) throws IndexOutOfBoundsException, IndexedFileException {
        byte[] byArray;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<RecordCoordinates> orphans;
            long subscript;
            int level;
            long power;
            long residue;
            block6: {
                boolean bl = false;
                if (index < 0L) {
                    throw new IndexOutOfBoundsException();
                }
                MasterNode masterNode = this.master;
                Intrinsics.checkNotNull((Object)masterNode);
                MasterNode m = masterNode;
                residue = index;
                power = this.fanoutRaisedTo(m.getOrphansByLevel().size() - 1);
                int n = m.getOrphansByLevel().size() + -1;
                if (0 <= n) {
                    do {
                        level = n--;
                        subscript = residue / power;
                        orphans = m.getOrphansByLevel().get(level);
                        if (subscript < (long)orphans.size()) break block6;
                        residue -= (long)orphans.size() * power;
                        power /= (long)this.fanout;
                    } while (0 <= n);
                }
                throw new IndexOutOfBoundsException();
            }
            byArray = this.recordAtZeroBasedIndex(residue % power, orphans.get((int)subscript), level);
        }
        finally {
            readLock.unlock();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSize() {
        long l;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            MasterNode masterNode = this.master;
            Intrinsics.checkNotNull((Object)masterNode);
            MasterNode $this$_get_size__u24lambda_u2d15_u24lambda_u2d14 = masterNode;
            boolean bl2 = false;
            long power = 1L;
            long sum = 0L;
            int n = $this$_get_size__u24lambda_u2d15_u24lambda_u2d14.getOrphansByLevel().size();
            for (int i = 0; i < n; ++i) {
                sum += (long)$this$_get_size__u24lambda_u2d15_u24lambda_u2d14.getOrphansByLevel().get(i).size() * power;
                power *= (long)this.fanout;
            }
            l = sum;
        }
        finally {
            readLock.unlock();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final byte[] getMetadata() {
        byte[] byArray;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            byte[] byArray2 = this.metadataCache;
            if (this.metadataCache == null) {
                MasterNode masterNode = this.master;
                Intrinsics.checkNotNull((Object)masterNode);
                MasterNode $this$_get_metadata__u24lambda_u2d17_u24lambda_u2d16 = masterNode;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)$this$_get_metadata__u24lambda_u2d17_u24lambda_u2d16.getMetadataLocation(), (Object)RecordCoordinates.Companion.getOrigin())) {
                    byArray2 = null;
                } else {
                    byte[] block = this.blockAtFilePosition($this$_get_metadata__u24lambda_u2d17_u24lambda_u2d16.getMetadataLocation().getFilePosition());
                    ByteBuffer buffer = ByteBuffer.wrap(block);
                    buffer.position($this$_get_metadata__u24lambda_u2d17_u24lambda_u2d16.getMetadataLocation().getBlockPosition());
                    byte[] bytes = new byte[buffer.getInt()];
                    buffer.get(bytes);
                    this.metadataCache = bytes;
                    byArray2 = bytes;
                }
            }
            byArray = byArray2;
        }
        finally {
            readLock.unlock();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMetadata(@Nullable byte[] newMetadata) {
        ReentrantReadWriteLock $this$safeWrite$iv = this.lock;
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            FileLock fileLock = this.longTermWriterLock;
            if (fileLock == null) {
                IndexedFile $this$_set_metadata__u24lambda_u2d20_u24lambda_u2d18 = this;
                boolean bl2 = false;
                $this$_set_metadata__u24lambda_u2d20_u24lambda_u2d18.longTermWriterLock = IndexedFile.acquireLockForWriting$default($this$_set_metadata__u24lambda_u2d20_u24lambda_u2d18, false, 1, null);
                $this$_set_metadata__u24lambda_u2d20_u24lambda_u2d18.refresh();
                fileLock = Unit.INSTANCE;
            }
            if (Arrays.equals(newMetadata, this.getMetadata())) {
                return;
            }
            MasterNode masterNode = this.master;
            Intrinsics.checkNotNull((Object)masterNode);
            MasterNode $this$_set_metadata__u24lambda_u2d20_u24lambda_u2d19 = masterNode;
            boolean bl3 = false;
            Object object = this.metadataCache = (Object)(newMetadata != null ? (byte[])newMetadata.clone() : null);
            if (newMetadata == null) {
                $this$_set_metadata__u24lambda_u2d20_u24lambda_u2d19.setMetadataLocation(RecordCoordinates.Companion.getOrigin());
            } else {
                $this$_set_metadata__u24lambda_u2d20_u24lambda_u2d19.setMetadataLocation(new RecordCoordinates($this$_set_metadata__u24lambda_u2d20_u24lambda_u2d19.getFileLimit(), $this$_set_metadata__u24lambda_u2d20_u24lambda_u2d19.getRawBytes().size()));
                $this$_set_metadata__u24lambda_u2d20_u24lambda_u2d19.getUncompressedData().writeInt(newMetadata.length);
                $this$_set_metadata__u24lambda_u2d20_u24lambda_u2d19.getUncompressedData().write(newMetadata);
                this.compressAndFlushIfFull();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refresh() throws IOException, IndexedFileException {
        ReentrantReadWriteLock $this$safeWrite$iv = this.lock;
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            FileLock fileLock = this.getChannel().lock(this.pageSize, (long)this.getMasterNodeSize$avail_storage() << 1, false);
            try {
                MasterNode previous = this.decodeMasterNode(this.previousMasterPosition);
                MasterNode current = this.decodeMasterNode(this.masterPosition);
                if (previous == null && current == null) {
                    throw new IndexedFileException("Invalid indexed file -- both master nodes are corrupt.");
                }
                Integer delta = null;
                if (previous != null && current != null && Math.abs(delta = Integer.valueOf(current.getSerialNumber() - previous.getSerialNumber())) != 1) {
                    throw new IndexedFileException("Invalid indexed file -- master nodes are valid but have non-consecutive serial numbers.");
                }
                if (previous != null && !Intrinsics.areEqual((Object)1, delta)) {
                    current = previous;
                    long tempPos = this.previousMasterPosition;
                    this.previousMasterPosition = this.masterPosition;
                    this.masterPosition = tempPos;
                }
                if (this.master != null) {
                    MasterNode masterNode = this.master;
                    Intrinsics.checkNotNull((Object)masterNode);
                    int n = masterNode.getSerialNumber();
                    MasterNode masterNode2 = current;
                    Intrinsics.checkNotNull((Object)masterNode2);
                    if (n != masterNode2.getSerialNumber()) {
                        MasterNode masterNode3 = this.master;
                        Intrinsics.checkNotNull((Object)masterNode3);
                        if (!Intrinsics.areEqual((Object)masterNode3.getMetadataLocation(), (Object)current.getMetadataLocation())) {
                            this.metadataCache = null;
                        }
                    }
                }
                this.master = current;
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
            catch (Throwable e) {
                this.close();
                throw new IndexedFileException(e);
            }
            finally {
                fileLock.release();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSize() + "] (for " + this.fileReference + ")";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/availlang/persistence/IndexedFile$ByteArrayOutputStream;", "Ljava/io/ByteArrayOutputStream;", "size", "", "(I)V", "unsafeBytes", "", "getUnsafeBytes", "()[B", "avail-storage"})
    public static final class ByteArrayOutputStream
    extends java.io.ByteArrayOutputStream {
        public ByteArrayOutputStream(int size) {
            super(size);
        }

        @NotNull
        public final byte[] getUnsafeBytes() {
            Intrinsics.checkNotNullExpressionValue((Object)this.buf, (String)"buf");
            return this.buf;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00180\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006+"}, d2={"Lorg/availlang/persistence/IndexedFile$MasterNode;", "", "serialNumber", "", "fileLimit", "", "(Lorg/availlang/persistence/IndexedFile;IJ)V", "getFileLimit", "()J", "setFileLimit", "(J)V", "lastPartialBuffer", "", "getLastPartialBuffer", "()[B", "setLastPartialBuffer", "([B)V", "metadataLocation", "Lorg/availlang/persistence/IndexedFile$RecordCoordinates;", "getMetadataLocation", "()Lorg/availlang/persistence/IndexedFile$RecordCoordinates;", "setMetadataLocation", "(Lorg/availlang/persistence/IndexedFile$RecordCoordinates;)V", "orphansByLevel", "", "getOrphansByLevel", "()Ljava/util/List;", "rawBytes", "Lorg/availlang/persistence/IndexedFile$ByteArrayOutputStream;", "getRawBytes", "()Lorg/availlang/persistence/IndexedFile$ByteArrayOutputStream;", "getSerialNumber", "()I", "setSerialNumber", "(I)V", "uncompressedData", "Ljava/io/DataOutputStream;", "getUncompressedData", "()Ljava/io/DataOutputStream;", "writeTo", "", "buffer", "Ljava/nio/ByteBuffer;", "avail-storage"})
    public final class MasterNode {
        private int serialNumber;
        private long fileLimit;
        @NotNull
        private final ByteArrayOutputStream rawBytes;
        @NotNull
        private final DataOutputStream uncompressedData;
        @NotNull
        private RecordCoordinates metadataLocation;
        @NotNull
        private final List<List<RecordCoordinates>> orphansByLevel;
        @NotNull
        private byte[] lastPartialBuffer;

        public MasterNode(int serialNumber, long fileLimit) {
            this.serialNumber = serialNumber;
            this.fileLimit = fileLimit;
            this.rawBytes = new ByteArrayOutputStream(IndexedFile.this.compressionBlockSize * 3 >> 1);
            this.uncompressedData = new DataOutputStream(this.rawBytes);
            this.metadataLocation = RecordCoordinates.Companion.getOrigin();
            this.orphansByLevel = new ArrayList();
            this.lastPartialBuffer = new byte[IndexedFile.this.pageSize];
        }

        public final int getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(int n) {
            this.serialNumber = n;
        }

        public final long getFileLimit() {
            return this.fileLimit;
        }

        public final void setFileLimit(long l) {
            this.fileLimit = l;
        }

        @NotNull
        public final ByteArrayOutputStream getRawBytes() {
            return this.rawBytes;
        }

        @NotNull
        public final DataOutputStream getUncompressedData() {
            return this.uncompressedData;
        }

        @NotNull
        public final RecordCoordinates getMetadataLocation() {
            return this.metadataLocation;
        }

        public final void setMetadataLocation(@NotNull RecordCoordinates recordCoordinates) {
            Intrinsics.checkNotNullParameter((Object)recordCoordinates, (String)"<set-?>");
            this.metadataLocation = recordCoordinates;
        }

        @NotNull
        public final List<List<RecordCoordinates>> getOrphansByLevel() {
            return this.orphansByLevel;
        }

        @NotNull
        public final byte[] getLastPartialBuffer() {
            return this.lastPartialBuffer;
        }

        public final void setLastPartialBuffer(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.lastPartialBuffer = byArray;
        }

        public final void writeTo(@NotNull ByteBuffer buffer) {
            int level;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            boolean bl2 = bl = this.rawBytes.size() < IndexedFile.this.compressionBlockSize;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int orphanCount = 0;
            for (List<RecordCoordinates> orphans : this.orphansByLevel) {
                orphanCount += orphans.size();
            }
            buffer.rewind();
            buffer.putInt(0);
            buffer.putInt(this.serialNumber);
            buffer.putLong(this.fileLimit);
            buffer.putInt(this.rawBytes.size());
            buffer.putLong(this.metadataLocation.getFilePosition());
            buffer.putInt(this.metadataLocation.getBlockPosition());
            buffer.putInt(orphanCount);
            int orphans = this.orphansByLevel.size();
            for (level = 0; level < orphans; ++level) {
                for (RecordCoordinates orphanLocation : this.orphansByLevel.get(level)) {
                    buffer.put((byte)(level + 1));
                    buffer.putLong(orphanLocation.getFilePosition());
                    buffer.putInt(orphanLocation.getBlockPosition());
                }
            }
            int n = level = buffer.position() <= IndexedFile.this.pageSize ? 1 : 0;
            if (_Assertions.ENABLED && level == 0) {
                boolean bl3 = false;
                String string = "Too much index orphan information for a page.";
                throw new AssertionError((Object)string);
            }
            buffer.put(new byte[IndexedFile.this.pageSize - buffer.position()]);
            int n2 = level = buffer.position() == IndexedFile.this.pageSize ? 1 : 0;
            if (_Assertions.ENABLED && level == 0) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            buffer.put(this.lastPartialBuffer);
            int n3 = level = buffer.position() == IndexedFile.this.pageSize << 1 ? 1 : 0;
            if (_Assertions.ENABLED && level == 0) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            buffer.put(this.rawBytes.getUnsafeBytes(), 0, this.rawBytes.size());
            buffer.put(new byte[IndexedFile.this.compressionBlockSize - this.rawBytes.size()]);
            int n4 = level = buffer.position() == buffer.capacity() ? 1 : 0;
            if (_Assertions.ENABLED && level == 0) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int n5 = level = buffer.position() == IndexedFile.this.getMasterNodeSize$avail_storage() ? 1 : 0;
            if (_Assertions.ENABLED && level == 0) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            CRC32 encoder = new CRC32();
            encoder.update(buffer.array(), 4, buffer.position() - 4);
            buffer.rewind();
            buffer.putInt((int)encoder.getValue());
            buffer.rewind();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/availlang/persistence/IndexedFile$RecordCoordinates;", "", "filePosition", "", "blockPosition", "", "(JI)V", "getBlockPosition", "()I", "getFilePosition", "()J", "equals", "", "other", "hashCode", "Companion", "avail-storage"})
    public static final class RecordCoordinates {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long filePosition;
        private final int blockPosition;
        @NotNull
        private static final RecordCoordinates origin = new RecordCoordinates(0L, 0);

        public RecordCoordinates(long filePosition, int blockPosition) {
            this.filePosition = filePosition;
            this.blockPosition = blockPosition;
        }

        public final long getFilePosition() {
            return this.filePosition;
        }

        public final int getBlockPosition() {
            return this.blockPosition;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof RecordCoordinates && this.filePosition == ((RecordCoordinates)other).filePosition && this.blockPosition == ((RecordCoordinates)other).blockPosition;
        }

        public int hashCode() {
            return (int)((this.filePosition ^ 0x58FC0112L) * (long)(this.blockPosition ^ 0xCACC77F3) + (long)1655712276);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/availlang/persistence/IndexedFile$RecordCoordinates$Companion;", "", "()V", "origin", "Lorg/availlang/persistence/IndexedFile$RecordCoordinates;", "getOrigin", "()Lorg/availlang/persistence/IndexedFile$RecordCoordinates;", "avail-storage"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final RecordCoordinates getOrigin() {
                return origin;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/availlang/persistence/IndexedFile$Companion;", "", "()V", "appendCRC", "", "byteStream", "Lorg/availlang/persistence/IndexedFile$ByteArrayOutputStream;", "validatedBytesFrom", "Ljava/io/ByteArrayInputStream;", "bytes", "", "avail-storage"})
    public static final class Companion {
        private Companion() {
        }

        public final void appendCRC(@NotNull ByteArrayOutputStream byteStream) {
            Intrinsics.checkNotNullParameter((Object)byteStream, (String)"byteStream");
            CRC32 checksum = new CRC32();
            checksum.update(byteStream.getUnsafeBytes(), 0, byteStream.size());
            byte[] bytes = new byte[4];
            ByteBuffer.wrap(bytes).putInt((int)checksum.getValue());
            byteStream.write(bytes);
        }

        @NotNull
        public final ByteArrayInputStream validatedBytesFrom(@NotNull byte[] bytes) throws MalformedSerialStreamException {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            int storedChecksum = ByteBuffer.wrap(bytes).getInt(bytes.length - 4);
            CRC32 checksum = new CRC32();
            checksum.update(bytes, 0, bytes.length - 4);
            if ((int)checksum.getValue() != storedChecksum) {
                throw new MalformedSerialStreamException(null);
            }
            return new ByteArrayInputStream(bytes, 0, bytes.length - 4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

