/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.persistence.tools.fileanalyzer;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.naming.ConfigurationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.LongIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.availlang.persistence.IndexedFile;
import org.availlang.persistence.IndexedFileBuilder;
import org.availlang.persistence.tools.fileanalyzer.configuration.CommandLineConfigurator;
import org.availlang.persistence.tools.fileanalyzer.configuration.IndexedFileAnalyzerConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000eJ\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J4\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00162\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J$\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lorg/availlang/persistence/tools/fileanalyzer/IndexedFileAnalyzer;", "", "configuration", "Lorg/availlang/persistence/tools/fileanalyzer/configuration/IndexedFileAnalyzerConfiguration;", "(Lorg/availlang/persistence/tools/fileanalyzer/configuration/IndexedFileAnalyzerConfiguration;)V", "builder", "Lorg/availlang/persistence/tools/fileanalyzer/IndexedFileAnalyzer$Companion$ArbitraryIndexedFileBuilder;", "indexedFile", "Lorg/availlang/persistence/IndexedFile;", "indices", "Lkotlin/ranges/LongRange;", "getIndices", "()Lkotlin/ranges/LongRange;", "analyze", "", "recordAcceptor", "Lkotlin/Function1;", "", "output", "Ljava/io/PrintStream;", "close", "stripUTF8", "", "input", "writeBinaryRow", "startIndex", "", "totalSize", "bytes", "rowAcceptor", "writeRecord", "recordNumber", "Companion", "avail-storage"})
public final class IndexedFileAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexedFileAnalyzerConfiguration configuration;
    @NotNull
    private final Companion.ArbitraryIndexedFileBuilder builder;
    @NotNull
    private final IndexedFile indexedFile;
    @NotNull
    private final LongRange indices;

    public IndexedFileAnalyzer(@NotNull IndexedFileAnalyzerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        if (this.configuration.getImplodeDirectory$avail_storage() != null) {
            IndexedFileAnalyzer.Companion.implode(this.configuration);
        }
        File file = this.configuration.getInputFile$avail_storage();
        Intrinsics.checkNotNull((Object)file);
        this.builder = new Companion.ArbitraryIndexedFileBuilder(file);
        IndexedFileBuilder indexedFileBuilder2 = this.builder;
        File file2 = this.configuration.getInputFile$avail_storage();
        Intrinsics.checkNotNull((Object)file2);
        this.indexedFile = IndexedFileBuilder.openOrCreate$default(indexedFileBuilder2, file2, false, null, 0, 0, 0, 0, 0, null, 508, null);
        this.indices = this.indices();
    }

    @NotNull
    public final LongRange getIndices() {
        return this.indices;
    }

    private final LongRange indices() {
        Long l = this.configuration.getLower$avail_storage();
        long l2 = l != null ? l : 0L;
        long l3 = 0L;
        long low = Math.max(l2, l3);
        Long l4 = this.configuration.getUpper$avail_storage();
        l3 = l4 != null ? l4 : Long.MAX_VALUE;
        long l5 = this.indexedFile.getSize() - 1L;
        long high = Math.min(l3, l5);
        return new LongRange(low, high);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeBinaryRow(long startIndex, long totalSize, byte[] bytes, Function1<? super String, Unit> rowAcceptor) {
        void $this$writeBinaryRow_u24lambda_u2d1;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        Function1<? super String, Unit> function1 = rowAcceptor;
        boolean bl = false;
        boolean bl2 = this.configuration.getBinary$avail_storage();
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String format = totalSize > 0x10000000L ? "%016X: " : (totalSize > 4096L ? "%08X: " : "%04X: ");
        Object[] objectArray = new Object[]{startIndex};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(format, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
        for (int i = 0; i < 16; ++i) {
            if (i == 8) {
                $this$writeBinaryRow_u24lambda_u2d1.append(" ");
            }
            if (i < bytes.length) {
                String string = " %02X";
                Object[] objectArray2 = new Object[]{bytes[i] & 0xFF};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(format, *args)");
                continue;
            }
            $this$writeBinaryRow_u24lambda_u2d1.append(" --");
        }
        if (this.configuration.getText$avail_storage()) {
            $this$writeBinaryRow_u24lambda_u2d1.append("  ");
            byte[] $this$forEachIndexed$iv = bytes;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (byte item$iv : $this$forEachIndexed$iv) {
                void b;
                void var20_25;
                int n = index$iv++;
                byte by = item$iv;
                int i = n;
                boolean bl3 = false;
                if (i == 8) {
                    $this$writeBinaryRow_u24lambda_u2d1.append(" ");
                }
                $this$writeBinaryRow_u24lambda_u2d1.append((char)((32 <= (var20_25 = b) ? var20_25 < 127 : false) ? (int)b : 46));
            }
        }
        $this$writeBinaryRow_u24lambda_u2d1.append('\n');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        function1.invoke((Object)string);
    }

    private final void writeRecord(long recordNumber, Function1<? super String, Unit> recordAcceptor) {
        byte[] byArray;
        if (recordNumber == -1L) {
            byArray = this.indexedFile.getMetadata();
            if (byArray == null) {
                return;
            }
        } else {
            byArray = this.indexedFile.get(recordNumber);
        }
        byte[] record = byArray;
        StringBuilder sb = new StringBuilder();
        IndexedFileAnalyzerConfiguration $this$writeRecord_u24lambda_u2d2 = this.configuration;
        boolean bl = false;
        if ($this$writeRecord_u24lambda_u2d2.getCounts$avail_storage()) {
            sb.append((String)(recordNumber == -1L ? "Metadata\n" : "Record=" + recordNumber + "\n"));
        }
        if ($this$writeRecord_u24lambda_u2d2.getSizes$avail_storage()) {
            sb.append("Size=" + record.length + "\n");
        }
        if ($this$writeRecord_u24lambda_u2d2.getBinary$avail_storage()) {
            int start = 0;
            int n = record.length;
            int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)16);
            if (start <= n2) {
                while (true) {
                    this.writeBinaryRow(start, record.length, ArraysKt.sliceArray((byte[])record, (IntRange)new IntRange(start, Math.min(start + 15, record.length - 1))), recordAcceptor);
                    if (start != n2) {
                        start += 16;
                        continue;
                    }
                    break;
                }
            }
        } else if ($this$writeRecord_u24lambda_u2d2.getText$avail_storage()) {
            sb.append(new String(record, Charsets.UTF_8));
        }
    }

    private final byte[] stripUTF8(byte[] input) throws Exception {
        boolean bl;
        CharBuffer charBuffer;
        CharsetDecoder decoder = Charsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        ByteBuffer sourceBuffer = ByteBuffer.wrap(input);
        try {
            charBuffer = decoder.decode(sourceBuffer);
        }
        catch (Throwable e) {
            throw new Exception("at position " + sourceBuffer.position() + ", " + e.getMessage());
        }
        CharBuffer string = charBuffer;
        ByteBuffer targetBuffer = ByteBuffer.allocate(string.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"string");
        Iterable $this$forEach$iv = (Iterable)StringsKt.getIndices((CharSequence)string);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl2 = false;
            char ch = string.get(i);
            if (Intrinsics.compare((int)ch, (int)255) > 0) {
                byte[] byArray = ((Object)((CharSequence)string).subSequence(0, i)).toString().getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                int pos = byArray.length;
                throw new Exception("at position " + pos + ", invalid encoding (" + ch + ").");
            }
            targetBuffer.put((byte)ch);
        }
        boolean bl3 = bl = targetBuffer.position() == string.length();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        byte[] byArray = targetBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"targetBuffer.array()");
        return byArray;
    }

    public final void close() {
        this.indexedFile.close();
    }

    public final void analyze(@NotNull PrintStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.analyze((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(output){
            final /* synthetic */ PrintStream $output;
            {
                this.$output = $output;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$output.append(it);
            }
        }));
    }

    public final void analyze(@NotNull Function1<? super String, Unit> recordAcceptor) {
        Intrinsics.checkNotNullParameter(recordAcceptor, (String)"recordAcceptor");
        IndexedFileAnalyzerConfiguration $this$analyze_u24lambda_u2d7 = this.configuration;
        boolean bl = false;
        if ($this$analyze_u24lambda_u2d7.getPatchOutputFile$avail_storage() != null) {
            boolean bl2;
            File file = $this$analyze_u24lambda_u2d7.getPatchOutputFile$avail_storage();
            Intrinsics.checkNotNull((Object)file);
            boolean bl3 = bl2 = !file.exists();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            IndexedFileBuilder indexedFileBuilder2 = this.builder;
            File file2 = $this$analyze_u24lambda_u2d7.getPatchOutputFile$avail_storage();
            Intrinsics.checkNotNull((Object)file2);
            IndexedFile outputFile = IndexedFileBuilder.openOrCreate$default(indexedFileBuilder2, file2, true, null, 0, 0, 0, 0, 0, null, 508, null);
            try {
                Iterable $this$forEach$iv = (Iterable)this.indices;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    byte[] byArray;
                    long element$iv;
                    long recordNumber = element$iv = ((LongIterator)iterator).nextLong();
                    boolean bl4 = false;
                    byte[] sourceRecord = this.indexedFile.get(recordNumber);
                    try {
                        byArray = this.stripUTF8(sourceRecord);
                    }
                    catch (Exception e) {
                        throw new Exception("In record " + recordNumber + ", " + e.getMessage());
                    }
                    byte[] targetRecord = byArray;
                    IndexedFile.add$default(outputFile, targetRecord, 0, 0, 6, null);
                }
                byte[] metadata = this.indexedFile.getMetadata();
                if (metadata != null) {
                    outputFile.setMetadata(metadata);
                }
                outputFile.commit();
                outputFile.close();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                outputFile.close();
                File file3 = $this$analyze_u24lambda_u2d7.getPatchOutputFile$avail_storage();
                Intrinsics.checkNotNull((Object)file3);
                file3.delete();
                throw e;
            }
        }
        if ($this$analyze_u24lambda_u2d7.getExplodeDirectory$avail_storage() != null) {
            byte[] metadataBytes;
            File file = $this$analyze_u24lambda_u2d7.getExplodeDirectory$avail_storage();
            Intrinsics.checkNotNull((Object)file);
            File dir = file;
            String suffix = $this$analyze_u24lambda_u2d7.getText$avail_storage() ? ".txt" : "";
            dir.mkdirs();
            Iterable $this$forEach$iv = (Iterable)this.indices;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                long element$iv;
                long it = element$iv = ((LongIterator)iterator).nextLong();
                boolean bl5 = false;
                FilesKt.writeBytes((File)FilesKt.resolve((File)dir, (String)(it + suffix)), (byte[])this.indexedFile.get(it));
            }
            if ($this$analyze_u24lambda_u2d7.getMetadata$avail_storage() && (metadataBytes = this.indexedFile.getMetadata()) != null) {
                FilesKt.writeBytes((File)FilesKt.resolve((File)dir, (String)("metadata" + suffix)), (byte[])metadataBytes);
            }
        } else if ($this$analyze_u24lambda_u2d7.getCounts$avail_storage() && !$this$analyze_u24lambda_u2d7.getBinary$avail_storage() && !$this$analyze_u24lambda_u2d7.getText$avail_storage() && !$this$analyze_u24lambda_u2d7.getSizes$avail_storage()) {
            int dir;
            int n = dir = !$this$analyze_u24lambda_u2d7.getMetadata$avail_storage() ? 1 : 0;
            if (_Assertions.ENABLED && dir == 0) {
                String suffix = "Assertion failed";
                throw new AssertionError((Object)suffix);
            }
            dir = CollectionsKt.count((Iterable)((Iterable)this.indices));
            System.out.println(dir);
        } else if ($this$analyze_u24lambda_u2d7.getCounts$avail_storage() || $this$analyze_u24lambda_u2d7.getSizes$avail_storage() || $this$analyze_u24lambda_u2d7.getBinary$avail_storage() || $this$analyze_u24lambda_u2d7.getText$avail_storage()) {
            Iterable $this$forEach$iv = (Iterable)this.indices;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                long element$iv;
                long it = element$iv = ((LongIterator)iterator).nextLong();
                boolean bl6 = false;
                this.writeRecord(it, recordAcceptor);
            }
            if ($this$analyze_u24lambda_u2d7.getMetadata$avail_storage()) {
                this.writeRecord(-1L, recordAcceptor);
            }
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\t\u001a\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\u00020\n*\u00020\u0004H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/availlang/persistence/tools/fileanalyzer/IndexedFileAnalyzer$Companion;", "", "()V", "configure", "Lorg/availlang/persistence/tools/fileanalyzer/configuration/IndexedFileAnalyzerConfiguration;", "args", "", "", "([Ljava/lang/String;)Lorg/availlang/persistence/tools/fileanalyzer/configuration/IndexedFileAnalyzerConfiguration;", "main", "", "([Ljava/lang/String;)V", "parseHeader", "file", "Ljava/io/File;", "implode", "ArbitraryIndexedFileBuilder", "ProcessResult", "avail-storage"})
    public static final class Companion {
        private Companion() {
        }

        private final void implode(IndexedFileAnalyzerConfiguration $this$implode) {
            String string;
            boolean bl;
            boolean bl2 = bl = $this$implode.getImplodeDirectory$avail_storage() != null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl3 = bl = $this$implode.getImplodeHeader$avail_storage() != null;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            boolean bl4 = bl = $this$implode.getImplodeOutput$avail_storage() != null;
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            boolean bl5 = bl = $this$implode.getInputFile$avail_storage() == null;
            if (_Assertions.ENABLED && !bl) {
                String string5 = "Assertion failed";
                throw new AssertionError((Object)string5);
            }
            File file = $this$implode.getImplodeDirectory$avail_storage();
            Intrinsics.checkNotNull((Object)file);
            File dir = file;
            File file2 = $this$implode.getImplodeOutput$avail_storage();
            Intrinsics.checkNotNull((Object)file2);
            File outputFile = file2;
            if (outputFile.exists()) {
                throw new Exception("Output file must not already exist");
            }
            Object[] objectArray = dir.list();
            Intrinsics.checkNotNull((Object)objectArray);
            List files = ArraysKt.toMutableList((Object[])objectArray);
            if (files.remove("metadata")) {
                if (files.contains("metadata.txt")) {
                    throw new Exception("Directory must not contain both 'metadata' and 'metadata.txt'.");
                }
                string = "metadata";
            } else {
                string = files.remove("metadata.txt") ? "metadata.txt" : null;
            }
            String metadata = string;
            Regex regex = new Regex("^(\\d+)(\\.txt)?$", RegexOption.IGNORE_CASE);
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (regex.matches((CharSequence)it)) continue;
                throw new Exception("Unexpected file '" + (String)it + "'. Implode directory entries must be numeric, or numeric+'.txt', and contiguous, starting at 0. Zero or one of 'metadata' or 'metadata.txt' is also supported.");
            }
            List $this$sortBy$iv = files;
            int $i$f$sortBy22 = 0;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(regex){
                    final /* synthetic */ Regex $regex$inlined;
                    {
                        this.$regex$inlined = regex;
                    }

                    public final int compare(T a, T b) {
                        String it = (String)a;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        Comparable comparable = Integer.valueOf(Integer.parseInt(this.$regex$inlined.replace((CharSequence)it, "$1")));
                        it = (String)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(Integer.parseInt(this.$regex$inlined.replace((CharSequence)it, "$1"))));
                    }
                });
            }
            $i$f$sortBy22 = files.size();
            for (int i = 0; i < $i$f$sortBy22; ++i) {
                String name = (String)files.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                String replacedName = regex.replace((CharSequence)name, "$1");
                if (Integer.parseInt(replacedName) == i) continue;
                if (Integer.parseInt(replacedName) == i - 1) {
                    throw new Exception("Directory must not contain both " + replacedName + " and " + replacedName + ".txt");
                }
                throw new Exception("Cannot find file '" + i + "' or '" + i + ".txt'.");
            }
            String string6 = $this$implode.getImplodeHeader$avail_storage();
            Intrinsics.checkNotNull((Object)string6);
            String $i$f$sortBy22 = string6;
            IndexedFileBuilder indexedFileBuilder2 = new IndexedFileBuilder($i$f$sortBy22){};
            IndexedFile out = IndexedFileBuilder.openOrCreate$default(indexedFileBuilder2, outputFile, true, null, 0, 0, 0, 0, 0, null, 508, null);
            Iterable $this$forEach$iv2 = files;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String it = (String)element$iv;
                boolean bl7 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                IndexedFile.add$default(out, FilesKt.readBytes((File)FilesKt.resolve((File)dir, (String)it)), 0, 0, 6, null);
            }
            String string7 = metadata;
            if (string7 != null) {
                String it = string7;
                boolean bl8 = false;
                out.setMetadata(FilesKt.readBytes((File)FilesKt.resolve((File)dir, (String)it)));
            }
            out.commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String parseHeader(@NotNull File file) {
            String string;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Closeable closeable = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);
            int n = 8192;
            closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            Throwable throwable = null;
            try {
                int ch;
                StringBuilder stringBuilder;
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                StringBuilder $this$parseHeader_u24lambda_u2d5_u24lambda_u2d4 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                while ((ch = it.read()) != 0) {
                    $this$parseHeader_u24lambda_u2d5_u24lambda_u2d4.append((char)ch);
                }
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                string = string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return string;
        }

        private final IndexedFileAnalyzerConfiguration configure(String[] args) throws ConfigurationException {
            IndexedFileAnalyzerConfiguration configuration = new IndexedFileAnalyzerConfiguration();
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
            CommandLineConfigurator commandLineConfigurator = new CommandLineConfigurator(configuration, args, printStream);
            commandLineConfigurator.updateConfiguration();
            return configuration;
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            try {
                IndexedFileAnalyzerConfiguration configuration = this.configure(args);
                IndexedFileAnalyzer indexedFileAnalyzer = new IndexedFileAnalyzer(configuration);
                PrintStream printStream = System.out;
                Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
                indexedFileAnalyzer.analyze(printStream);
            }
            catch (ConfigurationException e) {
                System.err.println(e.getMessage());
                System.exit(ProcessResult.CONFIGURATION_ERROR.getValue());
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(ProcessResult.OTHER_ERROR.getValue());
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/availlang/persistence/tools/fileanalyzer/IndexedFileAnalyzer$Companion$ProcessResult;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "OK", "CONFIGURATION_ERROR", "OTHER_ERROR", "avail-storage"})
        public static final class ProcessResult
        extends Enum<ProcessResult> {
            private final int value;
            public static final /* enum */ ProcessResult OK = new ProcessResult(0);
            public static final /* enum */ ProcessResult CONFIGURATION_ERROR = new ProcessResult(1);
            public static final /* enum */ ProcessResult OTHER_ERROR = new ProcessResult(2);
            private static final /* synthetic */ ProcessResult[] $VALUES;

            private ProcessResult(int value) {
                this.value = value;
            }

            public final int getValue() {
                return this.value;
            }

            public static ProcessResult[] values() {
                return (ProcessResult[])$VALUES.clone();
            }

            public static ProcessResult valueOf(String value) {
                return Enum.valueOf(ProcessResult.class, value);
            }

            static {
                $VALUES = processResultArray = new ProcessResult[]{ProcessResult.OK, ProcessResult.CONFIGURATION_ERROR, ProcessResult.OTHER_ERROR};
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/availlang/persistence/tools/fileanalyzer/IndexedFileAnalyzer$Companion$ArbitraryIndexedFileBuilder;", "Lorg/availlang/persistence/IndexedFileBuilder;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "avail-storage"})
        public static final class ArbitraryIndexedFileBuilder
        extends IndexedFileBuilder {
            public ArbitraryIndexedFileBuilder(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                super(Companion.parseHeader(file));
            }
        }
    }
}

