/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.persistence.tools.fileanalyzer.configuration;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.persistence.tools.fileanalyzer.configuration.CommandLineConfigurator;
import org.availlang.persistence.tools.fileanalyzer.configuration.Configuration;
import org.availlang.persistence.tools.fileanalyzer.configuration.ConfigurationException;
import org.availlang.persistence.tools.fileanalyzer.configuration.Configurator;
import org.availlang.persistence.tools.fileanalyzer.configuration.IndexedFileAnalyzerConfiguration;
import org.availlang.persistence.tools.options.OptionProcessingException;
import org.availlang.persistence.tools.options.OptionProcessor;
import org.availlang.persistence.tools.options.OptionProcessorFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/availlang/persistence/tools/fileanalyzer/configuration/CommandLineConfigurator;", "Lorg/availlang/persistence/tools/fileanalyzer/configuration/Configurator;", "Lorg/availlang/persistence/tools/fileanalyzer/configuration/IndexedFileAnalyzerConfiguration;", "configuration", "commandLineArguments", "", "", "helpStream", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "(Lorg/availlang/persistence/tools/fileanalyzer/configuration/IndexedFileAnalyzerConfiguration;[Ljava/lang/String;Ljava/lang/Appendable;)V", "[Ljava/lang/String;", "getConfiguration", "()Lorg/availlang/persistence/tools/fileanalyzer/configuration/IndexedFileAnalyzerConfiguration;", "isConfigured", "", "createOptionProcessor", "Lorg/availlang/persistence/tools/options/OptionProcessor;", "Lorg/availlang/persistence/tools/fileanalyzer/configuration/CommandLineConfigurator$OptionKey;", "updateConfiguration", "", "OptionKey", "avail-storage"})
public final class CommandLineConfigurator
implements Configurator<IndexedFileAnalyzerConfiguration> {
    @NotNull
    private final IndexedFileAnalyzerConfiguration configuration;
    @NotNull
    private final Appendable helpStream;
    @NotNull
    private final String[] commandLineArguments;
    private boolean isConfigured;

    public CommandLineConfigurator(@NotNull IndexedFileAnalyzerConfiguration configuration, @NotNull String[] commandLineArguments, @NotNull Appendable helpStream) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)commandLineArguments, (String)"commandLineArguments");
        Intrinsics.checkNotNullParameter((Object)helpStream, (String)"helpStream");
        this.configuration = configuration;
        this.helpStream = helpStream;
        this.commandLineArguments = (String[])commandLineArguments.clone();
    }

    @Override
    @NotNull
    public IndexedFileAnalyzerConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - void declaration
     */
    private final OptionProcessor<OptionKey> createOptionProcessor() {
        void this_$iv;
        OptionProcessorFactory.Companion companion = OptionProcessorFactory.Companion;
        Function1 setup$iv = (Function1)new Function1<OptionProcessorFactory<OptionKey>, Unit>(this){
            final /* synthetic */ CommandLineConfigurator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull OptionProcessorFactory<OptionKey> $this$create) {
                Intrinsics.checkNotNullParameter($this$create, (String)"$this$create");
                Object[] objectArray = new String[]{"c", "counts"};
                OptionProcessorFactory.option$default($this$create, OptionKey.COUNTS, CollectionsKt.listOf((Object[])objectArray), "Whether to show 'Record=', the zero-based record number, and a linefeed prior to each record that is output.  If neither -s nor -b nor -t is specified, only the undecorated count of the number of eligible records is output.  In that case, -m is forbidden.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocation<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocation<OptionKey> $this$option) {
                        Intrinsics.checkNotNullParameter($this$option, (String)"$this$option");
                        this.this$0.getConfiguration().setCounts$avail_storage(true);
                    }
                }, 8, null);
                objectArray = new String[]{"s", "sizes"};
                OptionProcessorFactory.option$default($this$create, OptionKey.SIZES, CollectionsKt.listOf((Object[])objectArray), "Whether to show record sizes prior to each record.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocation<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocation<OptionKey> $this$option) {
                        Intrinsics.checkNotNullParameter($this$option, (String)"$this$option");
                        this.this$0.getConfiguration().setSizes$avail_storage(true);
                    }
                }, 8, null);
                objectArray = new String[]{"b", "binary"};
                OptionProcessorFactory.option$default($this$create, OptionKey.BINARY, CollectionsKt.listOf((Object[])objectArray), "Whether to show each byte of records and/or metadata in hexadecimal.  Can be combined with -t.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocation<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocation<OptionKey> $this$option) {
                        Intrinsics.checkNotNullParameter($this$option, (String)"$this$option");
                        this.this$0.getConfiguration().setBinary$avail_storage(true);
                    }
                }, 8, null);
                objectArray = new String[]{"t", "text"};
                OptionProcessorFactory.option$default($this$create, OptionKey.TEXT, CollectionsKt.listOf((Object[])objectArray), "Whether to treat each record as a UTF-8 encoded Unicode string, and output it as text.  If combined with -b, the left side contains hex bytes and the right side contains printable ASCII characters (0x20-0x7E) or a '.'.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocation<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocation<OptionKey> $this$option) {
                        Intrinsics.checkNotNullParameter($this$option, (String)"$this$option");
                        this.this$0.getConfiguration().setText$avail_storage(true);
                    }
                }, 8, null);
                objectArray = new String[]{"x", "explode"};
                OptionProcessorFactory.optionWithArgument$default($this$create, OptionKey.EXPLODE, CollectionsKt.listOf((Object[])objectArray), "A directory to use or create, into which records and/or metadata will be written in separate files.  If -t is specified, '.txt' will be appended to the filenames.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocationWithArgument<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocationWithArgument<OptionKey> $this$optionWithArgument) {
                        Intrinsics.checkNotNullParameter($this$optionWithArgument, (String)"$this$optionWithArgument");
                        this.this$0.getConfiguration().setExplodeDirectory$avail_storage(new File($this$optionWithArgument.getArgument()));
                    }
                }, 8, null);
                OptionProcessorFactory.optionWithArgument$default($this$create, OptionKey.IMPLODE, CollectionsKt.listOf((Object)"implode"), "Specifies a directory to read, from which records and/or metadata will be retrieved and written to a new index file.  The directory is expected to contain files with names '0' or '0.txt', '1' or '1.txt', etc., and optionally either 'metadata' or 'metadata.txt'.  If the numbered files do not form a contiguous range starting at 0, or if there are files in the directory that do not match this pattern, the command will fail without creating the file.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocationWithArgument<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocationWithArgument<OptionKey> $this$optionWithArgument) {
                        Intrinsics.checkNotNullParameter($this$optionWithArgument, (String)"$this$optionWithArgument");
                        this.this$0.getConfiguration().setImplodeDirectory$avail_storage(new File($this$optionWithArgument.getArgument()));
                    }
                }, 8, null);
                OptionProcessorFactory.optionWithArgument$default($this$create, OptionKey.IMPLODE_HEADER, CollectionsKt.listOf((Object)"implode-header"), "Specifies the header string that identifies the type of indexed file that should be created via the 'implode' command.  This option must be provided whenever'implode' is specified, and vice-versa.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocationWithArgument<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocationWithArgument<OptionKey> $this$optionWithArgument) {
                        Intrinsics.checkNotNullParameter($this$optionWithArgument, (String)"$this$optionWithArgument");
                        this.this$0.getConfiguration().setImplodeHeader$avail_storage($this$optionWithArgument.getArgument());
                    }
                }, 8, null);
                OptionProcessorFactory.optionWithArgument$default($this$create, OptionKey.IMPLODE_OUTPUT, CollectionsKt.listOf((Object)"implode-output"), "Specifies the name of the indexed file that should be created by the --implode command.  This option must be provided whenever 'implode' is specified, and vice-versa.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocationWithArgument<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocationWithArgument<OptionKey> $this$optionWithArgument) {
                        Intrinsics.checkNotNullParameter($this$optionWithArgument, (String)"$this$optionWithArgument");
                        this.this$0.getConfiguration().setImplodeOutput$avail_storage(new File($this$optionWithArgument.getArgument()));
                    }
                }, 8, null);
                objectArray = new String[]{"m", "metadata"};
                OptionProcessorFactory.option$default($this$create, OptionKey.METADATA, CollectionsKt.listOf((Object[])objectArray), "Whether to process metadata of the input file.  If specified, and if the metadata is present and non-empty, the metadata will be processed in the same way as the records, after the last record, if any.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocation<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocation<OptionKey> $this$option) {
                        Intrinsics.checkNotNullParameter($this$option, (String)"$this$option");
                        this.this$0.getConfiguration().setMetadata$avail_storage(true);
                    }
                }, 8, null);
                objectArray = new String[]{"l", "lower"};
                OptionProcessorFactory.optionWithArgument$default($this$create, OptionKey.LOWER, CollectionsKt.listOf((Object[])objectArray), "The lowest zero-based record number that may be processed.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocationWithArgument<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocationWithArgument<OptionKey> $this$optionWithArgument) {
                        Intrinsics.checkNotNullParameter($this$optionWithArgument, (String)"$this$optionWithArgument");
                        try {
                            long value = Long.parseLong($this$optionWithArgument.getArgument());
                            if (value < 0L) {
                                throw new OptionProcessingException($this$optionWithArgument.getKeyword() + ": Argument must be \u2265 0");
                            }
                            this.this$0.getConfiguration().setLower$avail_storage(value);
                        }
                        catch (NumberFormatException e) {
                            throw new OptionProcessingException($this$optionWithArgument.getKeyword() + ": Illegal argument.", e);
                        }
                    }
                }, 8, null);
                objectArray = new String[]{"u", "upper"};
                OptionProcessorFactory.optionWithArgument$default($this$create, OptionKey.UPPER, CollectionsKt.listOf((Object[])objectArray), "The highest zero-based record number that may be processed.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocationWithArgument<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocationWithArgument<OptionKey> $this$optionWithArgument) {
                        Intrinsics.checkNotNullParameter($this$optionWithArgument, (String)"$this$optionWithArgument");
                        try {
                            long value = Long.parseLong($this$optionWithArgument.getArgument());
                            if (value < -1L) {
                                throw new OptionProcessingException($this$optionWithArgument.getKeyword() + ": Argument must be \u2265 -1");
                            }
                            this.this$0.getConfiguration().setUpper$avail_storage(value);
                        }
                        catch (NumberFormatException e) {
                            throw new OptionProcessingException($this$optionWithArgument.getKeyword() + ": Illegal argument.", e);
                        }
                    }
                }, 8, null);
                OptionProcessorFactory.optionWithArgument$default($this$create, OptionKey.PATCH_RECORDS_STRIPPING_UTF8, CollectionsKt.listOf((Object)"patch-utf-8"), "TEMPORARY FEATURE \u2013 Create a new file, named by the argument, unwrapping a layer of UTF-8 by decoding it as UTF-8 to a string, failing immediately if any character is not Latin-1 (U+0000 - U+00FF).  With each such string, write the characters with Latin-1 encoding, i.e., one byte per character.", null, (Function1)new Function1<OptionProcessorFactory.OptionInvocationWithArgument<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocationWithArgument<OptionKey> $this$optionWithArgument) {
                        Intrinsics.checkNotNullParameter($this$optionWithArgument, (String)"$this$optionWithArgument");
                        File file = new File($this$optionWithArgument.getArgument());
                        this.this$0.getConfiguration().setPatchOutputFile$avail_storage(file);
                        if (file.exists()) {
                            throw new OptionProcessingException("Error - destination file (" + $this$optionWithArgument.getArgument() + ") already exists.");
                        }
                    }
                }, 8, null);
                $this$create.helpOption((OptionKey)((Enum)OptionKey.HELP), "The IndexedFileAnalyzer understands these options:", CommandLineConfigurator.access$getHelpStream$p(this.this$0));
                $this$create.defaultOption((OptionKey)((Enum)OptionKey.INDEXED_FILE), "The indexed file to analyze.", OptionProcessorFactory.Cardinality.Companion.getOPTIONAL(), (Function1<OptionProcessorFactory.OptionInvocationWithArgument<OptionKey>, Unit>)((Function1)new Function1<OptionProcessorFactory.OptionInvocationWithArgument<OptionKey>, Unit>(this.this$0){
                    final /* synthetic */ CommandLineConfigurator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull OptionProcessorFactory.OptionInvocationWithArgument<OptionKey> $this$defaultOption) {
                        Intrinsics.checkNotNullParameter($this$defaultOption, (String)"$this$defaultOption");
                        try {
                            if (!new File($this$defaultOption.getArgument()).isFile()) {
                                throw new OptionProcessingException("File not found, or directory was specified");
                            }
                            this.this$0.getConfiguration().setInputFile$avail_storage(new File($this$defaultOption.getArgument()));
                        }
                        catch (OptionProcessingException e) {
                            throw new OptionProcessingException("\u00abdefault\u00bb: " + e.getMessage(), e);
                        }
                    }
                }));
                $this$create.rule((Configuration)this.this$0.getConfiguration(), "Neither an input file nor --implode was specified", createOptionProcessor.14.INSTANCE);
                $this$create.rule((Configuration)this.this$0.getConfiguration(), "--explode cannot produce --binary & --text combination", createOptionProcessor.15.INSTANCE);
                $this$create.rule((Configuration)this.this$0.getConfiguration(), "If only --counts are requested (not --sizes, -binary, or --text, then --metadata must not be specified", createOptionProcessor.16.INSTANCE);
                $this$create.rule((Configuration)this.this$0.getConfiguration(), "The '--implode' option, the '--implode-header' option, and --implode-output option must be used together, with no other options.", createOptionProcessor.17.INSTANCE);
                $this$create.rule((Configuration)this.this$0.getConfiguration(), "The '--patch-utf-8' option is incompatible with --counts, --sizes, --binary, --text, --explode, or --metadata.", createOptionProcessor.18.INSTANCE);
            }
        };
        boolean $i$f$create = false;
        return this_$iv.privateCreate(OptionKey.class, setup$iv);
    }

    @Override
    public synchronized void updateConfiguration() throws ConfigurationException {
        if (!this.isConfigured) {
            try {
                this.createOptionProcessor().processOptions(this.commandLineArguments);
                this.isConfigured = true;
            }
            catch (Exception e) {
                throw new ConfigurationException("configuration error: " + e.getMessage(), e);
            }
        }
    }

    public static final /* synthetic */ Appendable access$getHelpStream$p(CommandLineConfigurator $this) {
        return $this.helpStream;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0010\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/availlang/persistence/tools/fileanalyzer/configuration/CommandLineConfigurator$OptionKey;", "", "(Ljava/lang/String;I)V", "COUNTS", "SIZES", "BINARY", "TEXT", "EXPLODE", "IMPLODE", "IMPLODE_HEADER", "IMPLODE_OUTPUT", "METADATA", "LOWER", "UPPER", "PATCH_RECORDS_STRIPPING_UTF8", "HELP", "INDEXED_FILE", "avail-storage"})
    public static final class OptionKey
    extends Enum<OptionKey> {
        public static final /* enum */ OptionKey COUNTS = new OptionKey();
        public static final /* enum */ OptionKey SIZES = new OptionKey();
        public static final /* enum */ OptionKey BINARY = new OptionKey();
        public static final /* enum */ OptionKey TEXT = new OptionKey();
        public static final /* enum */ OptionKey EXPLODE = new OptionKey();
        public static final /* enum */ OptionKey IMPLODE = new OptionKey();
        public static final /* enum */ OptionKey IMPLODE_HEADER = new OptionKey();
        public static final /* enum */ OptionKey IMPLODE_OUTPUT = new OptionKey();
        public static final /* enum */ OptionKey METADATA = new OptionKey();
        public static final /* enum */ OptionKey LOWER = new OptionKey();
        public static final /* enum */ OptionKey UPPER = new OptionKey();
        public static final /* enum */ OptionKey PATCH_RECORDS_STRIPPING_UTF8 = new OptionKey();
        public static final /* enum */ OptionKey HELP = new OptionKey();
        public static final /* enum */ OptionKey INDEXED_FILE = new OptionKey();
        private static final /* synthetic */ OptionKey[] $VALUES;

        public static OptionKey[] values() {
            return (OptionKey[])$VALUES.clone();
        }

        public static OptionKey valueOf(String value) {
            return Enum.valueOf(OptionKey.class, value);
        }

        static {
            $VALUES = optionKeyArray = new OptionKey[]{OptionKey.COUNTS, OptionKey.SIZES, OptionKey.BINARY, OptionKey.TEXT, OptionKey.EXPLODE, OptionKey.IMPLODE, OptionKey.IMPLODE_HEADER, OptionKey.IMPLODE_OUTPUT, OptionKey.METADATA, OptionKey.LOWER, OptionKey.UPPER, OptionKey.PATCH_RECORDS_STRIPPING_UTF8, OptionKey.HELP, OptionKey.INDEXED_FILE};
        }
    }
}

