/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.persistence.tools.utility;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B9\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/availlang/persistence/tools/utility/ParagraphFormatter;", "", "windowWidth", "", "leftMargin", "rightMargin", "firstIndent", "restIndent", "(IIIII)V", "fIndent", "", "getFirstIndent", "()I", "getLeftMargin", "margin", "rIndent", "getRestIndent", "getRightMargin", "getWindowWidth", "format", "str", "Companion", "avail-storage"})
public final class ParagraphFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int windowWidth;
    private final int leftMargin;
    private final int rightMargin;
    private final int firstIndent;
    private final int restIndent;
    @NotNull
    private final String margin;
    @NotNull
    private final String fIndent;
    @NotNull
    private final String rIndent;

    @JvmOverloads
    public ParagraphFormatter(int windowWidth, int leftMargin, int rightMargin, int firstIndent, int restIndent) {
        this.windowWidth = windowWidth;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.firstIndent = firstIndent;
        this.restIndent = restIndent;
        this.margin = ParagraphFormatter.Companion.padding(this.leftMargin);
        this.fIndent = ParagraphFormatter.Companion.padding(this.firstIndent);
        this.rIndent = ParagraphFormatter.Companion.padding(this.restIndent);
    }

    public /* synthetic */ ParagraphFormatter(int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            n = 80;
        }
        if ((n6 & 2) != 0) {
            n2 = 0;
        }
        if ((n6 & 4) != 0) {
            n3 = 0;
        }
        if ((n6 & 8) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n5 = 0;
        }
        this(n, n2, n3, n4, n5);
    }

    public final int getWindowWidth() {
        return this.windowWidth;
    }

    public final int getLeftMargin() {
        return this.leftMargin;
    }

    public final int getRightMargin() {
        return this.rightMargin;
    }

    public final int getFirstIndent() {
        return this.firstIndent;
    }

    public final int getRestIndent() {
        return this.restIndent;
    }

    @NotNull
    public final String format(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String input = str;
        String nwln = System.getProperty("line.separator");
        Intrinsics.checkNotNullExpressionValue((Object)nwln, (String)"nwln");
        input = ParagraphFormatter.Companion.replaceSeparators(input, nwln);
        CharSequence charSequence = input;
        Regex regex = new Regex("[^\\S\n\r]");
        String string = " ";
        input = regex.replace(charSequence, string);
        int lineWidth = this.windowWidth - this.leftMargin - this.rightMargin;
        StringBuilder output = new StringBuilder();
        while (((CharSequence)input).length() > 0) {
            String paragraph;
            int newlineIndex = StringsKt.indexOf$default((CharSequence)input, (String)nwln, (int)0, (boolean)false, (int)6, null);
            if (newlineIndex == 0) {
                output.append(nwln);
                Intrinsics.checkNotNullExpressionValue((Object)input.substring(1), (String)"this as java.lang.String).substring(startIndex)");
                continue;
            }
            if (newlineIndex < 0) {
                newlineIndex = input.length();
            }
            Intrinsics.checkNotNullExpressionValue((Object)input.substring(0, newlineIndex), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)input.substring(paragraph.length() + 1), (String)"this as java.lang.String).substring(startIndex)");
            String indent = this.fIndent;
            int adjustedLineWidth = lineWidth - this.firstIndent;
            while (((CharSequence)paragraph).length() > 0) {
                int lastIndex = adjustedLineWidth + 1;
                String currentLine = paragraph;
                if (lastIndex < currentLine.length()) {
                    String string2 = paragraph.substring(0, lastIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    int cutoff = StringsKt.lastIndexOf$default((CharSequence)string2, (char)' ', (int)0, (boolean)false, (int)6, null);
                    if (cutoff < 0) {
                        cutoff = StringsKt.indexOf$default((CharSequence)paragraph, (char)' ', (int)0, (boolean)false, (int)6, null);
                    }
                    String string3 = paragraph.substring(0, cutoff);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    currentLine = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)paragraph.substring(cutoff + 1), (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    paragraph = "";
                }
                output.append(this.margin);
                output.append(indent);
                output.append(currentLine);
                output.append(nwln);
                if (!Intrinsics.areEqual((Object)indent, (Object)this.fIndent)) continue;
                indent = this.rIndent;
                adjustedLineWidth = lineWidth - this.restIndent;
            }
        }
        String string4 = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"output.toString()");
        return string4;
    }

    @JvmOverloads
    public ParagraphFormatter(int windowWidth, int leftMargin, int rightMargin, int firstIndent) {
        this(windowWidth, leftMargin, rightMargin, firstIndent, 0, 16, null);
    }

    @JvmOverloads
    public ParagraphFormatter(int windowWidth, int leftMargin, int rightMargin) {
        this(windowWidth, leftMargin, rightMargin, 0, 0, 24, null);
    }

    @JvmOverloads
    public ParagraphFormatter(int windowWidth, int leftMargin) {
        this(windowWidth, leftMargin, 0, 0, 0, 28, null);
    }

    @JvmOverloads
    public ParagraphFormatter(int windowWidth) {
        this(windowWidth, 0, 0, 0, 0, 30, null);
    }

    @JvmOverloads
    public ParagraphFormatter() {
        this(0, 0, 0, 0, 0, 31, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lorg/availlang/persistence/tools/utility/ParagraphFormatter$Companion;", "", "()V", "padding", "", "len", "", "replaceSeparators", "input", "separator", "avail-storage"})
    public static final class Companion {
        private Companion() {
        }

        private final String replaceSeparators(String input, String separator) {
            String result = input;
            result = StringsKt.replace$default((String)result, (String)"\r\n", (String)separator, (boolean)false, (int)4, null);
            result = StringsKt.replace$default((String)result, (String)"\r", (String)separator, (boolean)false, (int)4, null);
            result = StringsKt.replace$default((String)result, (String)"\n", (String)separator, (boolean)false, (int)4, null);
            return result;
        }

        private final String padding(int len) {
            StringBuilder padding = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                padding.append(' ');
            }
            String string = padding.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"padding.toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

