/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.agentloader;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import org.avaje.agentloader.find.ByClassNameJarFinder;
import org.avaje.agentloader.find.ByPrefixJarFinder;
import org.avaje.agentloader.find.FindResult;
import org.avaje.agentloader.find.JarFinder;
import org.avaje.agentloader.load.DirectLoader;
import org.avaje.agentloader.load.ExternalLoader;
import org.avaje.agentloader.load.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentLoader {
    private static final Logger log = LoggerFactory.getLogger(AgentLoader.class);
    private static final List<String> loaded = new ArrayList<String>();
    private static final String JDK_ALLOW_SELF_ATTACH = "jdk.attach.allowAttachSelf";

    private static boolean directAttach() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            log.trace("using direct-attach for java {} < 9", (Object)version);
            return true;
        }
        if (Boolean.getBoolean(JDK_ALLOW_SELF_ATTACH)) {
            log.trace("using direct-attach, because {} is set", (Object)JDK_ALLOW_SELF_ATTACH);
            return true;
        }
        log.trace("using external-attach for java {}", (Object)version);
        return false;
    }

    private static final String discoverPid() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }

    public static boolean loadAgent(String jarFilePath) {
        return AgentLoader.loadAgent(jarFilePath, "");
    }

    public static synchronized boolean loadAgent(String jarFilePath, String params) {
        if (loaded.contains(jarFilePath)) {
            return false;
        }
        long time = System.currentTimeMillis();
        log.info("dynamically loading javaagent for {}", (Object)jarFilePath);
        String pid = AgentLoader.discoverPid();
        try {
            Loader loader = AgentLoader.directAttach() ? new DirectLoader() : new ExternalLoader();
            loader.loadAgent(jarFilePath, pid, params);
            time = System.currentTimeMillis() - time;
            log.info("agent loaded by {} in {} ms", (Object)loader.getClass().getSimpleName(), (Object)time);
            loaded.add(jarFilePath);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean loadAgentFromClasspath(String agentName) {
        return AgentLoader.loadAgentFromClasspath(agentName, "");
    }

    public static synchronized boolean loadAgentFromClasspath(String agentName, String params) {
        return AgentLoader.loadAgentFromClasspath(agentName, AgentLoader.getClassLoader(), params);
    }

    public static synchronized boolean loadAgentFromClasspath(String agentName, ClassLoader cl, String params) {
        if (loaded.contains(agentName)) {
            return true;
        }
        ByPrefixJarFinder finder = new ByPrefixJarFinder();
        try (FindResult result = finder.find(agentName, cl);){
            if (result != null) {
                boolean ret = AgentLoader.loadAgent(result.getFile().getAbsolutePath(), params);
                loaded.add(agentName);
                boolean bl = ret;
                return bl;
            }
        }
        return false;
    }

    public static boolean loadAgentByMainClass(String mainClass) {
        return AgentLoader.loadAgentByMainClass(mainClass, "");
    }

    public static synchronized boolean loadAgentByMainClass(String mainClass, String params) {
        return AgentLoader.loadAgentByMainClass(mainClass, AgentLoader.getClassLoader(), params);
    }

    public static synchronized boolean loadAgentByMainClass(String mainClass, ClassLoader cl, String params) {
        if (loaded.contains(mainClass)) {
            return true;
        }
        ByClassNameJarFinder finder = new ByClassNameJarFinder();
        try (FindResult result = finder.find(mainClass, cl);){
            if (result != null) {
                boolean ret = AgentLoader.loadAgent(result.getFile().getAbsolutePath(), params);
                loaded.add(mainClass);
                boolean bl = ret;
                return bl;
            }
        }
        return false;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = JarFinder.class.getClassLoader();
        }
        return cl;
    }
}

