/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.agentloader.find;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.avaje.agentloader.find.JarFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByClassNameJarFinder
extends JarFinder {
    private static final Logger log = LoggerFactory.getLogger(ByClassNameJarFinder.class);

    private URL stripUrl(URL url, String classFile) throws MalformedURLException {
        if (url == null) {
            return null;
        }
        String tmp = url.toString();
        if (!tmp.endsWith(classFile)) {
            return null;
        }
        if ((tmp = tmp.substring(0, tmp.length() - classFile.length())).startsWith("jar:")) {
            if (tmp.endsWith("!/")) {
                tmp = tmp.substring(0, tmp.length() - 2);
            }
            if (!tmp.contains("!/") && tmp.startsWith("jar:file:")) {
                tmp = tmp.substring(4);
            }
        }
        return new URL(url, tmp, null);
    }

    @Override
    protected List<URL> findCandidates(String query, ClassLoader cl) {
        ArrayList<URL> candidates;
        block7: {
            String classFile = query.replace('.', '/') + ".class";
            candidates = new ArrayList<URL>();
            try {
                URL url = cl.getResource(classFile);
                url = this.stripUrl(url, classFile);
                if (url != null) {
                    candidates.add(url);
                    break block7;
                }
                try {
                    CodeSource cs;
                    Class<?> clazz = cl.loadClass(query);
                    ProtectionDomain pd = clazz.getProtectionDomain();
                    CodeSource codeSource = cs = pd == null ? null : pd.getCodeSource();
                    if (cs != null) {
                        candidates.add(cs.getLocation());
                    }
                }
                catch (ClassNotFoundException clazz) {
                }
                catch (Exception e) {
                    log.warn("Cannot find code-source for {}", (Object)query, (Object)e);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return candidates;
    }
}

