/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.agentloader.find;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.avaje.agentloader.find.JarFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByPrefixJarFinder
extends JarFinder {
    private static final Logger log = LoggerFactory.getLogger(ByPrefixJarFinder.class);

    private Set<URL> getClasspathUrls(ClassLoader cl) {
        LinkedHashSet<URL> ret = new LinkedHashSet<URL>();
        if (cl instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                ret.add(url);
            }
        }
        String[] cpFiles = System.getProperty("java.class.path").split(File.pathSeparator);
        try {
            for (int i = 0; i < cpFiles.length; ++i) {
                ret.add(new File(cpFiles[i]).toURI().toURL());
            }
        }
        catch (MalformedURLException mfe) {
            log.error("Cannot determine classpathUrls", (Throwable)mfe);
        }
        return ret;
    }

    @Override
    protected List<URL> findCandidates(String query, ClassLoader cl) {
        ArrayList<URL> candidates = new ArrayList<URL>();
        Set<URL> urls = this.getClasspathUrls(cl);
        for (URL url : urls) {
            if (!this.isMatch(url, query) || candidates.contains(url)) continue;
            candidates.add(url);
        }
        if (candidates.isEmpty() && log.isTraceEnabled()) {
            log.debug("Urls in classpath:");
            for (URL url : urls) {
                log.trace("  url: {}", (Object)url);
            }
        }
        return candidates;
    }
}

