/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.agentloader.find;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.avaje.agentloader.find.FindResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JarFinder {
    private static final Logger log = LoggerFactory.getLogger(JarFinder.class);
    private static final int IO_BUFFER_SIZE = 4096;

    public FindResult find(String query, ClassLoader cl) {
        log.debug("searching for {}", (Object)query);
        List<URL> candidates = this.findCandidates(query, cl);
        if (candidates.isEmpty()) {
            log.debug("Could not find {}.", (Object)query);
            return null;
        }
        if (candidates.size() > 1) {
            log.warn("Query for {} is ambiguous. Using first candidate of {}", (Object)query, candidates);
        }
        try {
            URL url = candidates.get(0);
            FindResult jar = null;
            jar = this.isJarInJar(url) ? this.extractJar(url, query) : new FindResult(new File(url.toURI()), false);
            return jar;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract List<URL> findCandidates(String var1, ClassLoader var2);

    protected boolean isJarInJar(URL url) {
        return url.getProtocol().equals("jar") && url.getPath().contains("!/");
    }

    protected boolean isMatch(URL url, String partial) {
        log.trace("isMatch('{}','{}')", (Object)url, (Object)partial);
        String fullPath = url.getFile();
        int lastJar = fullPath.lastIndexOf(".jar");
        if (lastJar < 0) {
            return false;
        }
        int lastSlash = fullPath.lastIndexOf(47, lastJar);
        if (lastSlash < 0) {
            return false;
        }
        String jarName = fullPath.substring(lastSlash + 1, lastJar + 4);
        return jarName.startsWith(partial);
    }

    protected FindResult extractJar(URL path, String agentName) {
        File fullPath = null;
        log.debug("Extracting agent {} from source {}", (Object)agentName, (Object)path.getPath());
        try {
            fullPath = File.createTempFile(agentName, ".jar");
            try (InputStream is = path.openStream();
                 BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(fullPath));){
                this.copyBytes(is, os);
                log.debug("Extracted jar to {}", (Object)fullPath);
            }
        }
        catch (Exception ex) {
            log.error("Failed to extract jar {}", (Object)path, (Object)ex);
        }
        return fullPath == null ? null : new FindResult(fullPath, true);
    }

    protected long copyBytes(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

