/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.agentloader.load;

import java.io.File;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.avaje.agentloader.AgentLoader;
import org.avaje.agentloader.find.ByClassNameJarFinder;
import org.avaje.agentloader.find.FindResult;
import org.avaje.agentloader.load.DirectLoader;
import org.avaje.agentloader.load.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalLoader
implements Loader {
    private static final Logger log = LoggerFactory.getLogger(AgentLoader.class);

    private static String quote(String value) {
        return value.contains(" ") ? '\"' + value + '\"' : value;
    }

    public static final boolean isWindows() {
        return File.separatorChar == '\\';
    }

    @Override
    public void loadAgent(String jarFilePath, String pid, String params) throws Exception {
        ByClassNameJarFinder finder = new ByClassNameJarFinder();
        try (FindResult result = finder.find(AgentLoader.class.getName(), AgentLoader.class.getClassLoader());){
            File classPath = null;
            if (result != null) {
                classPath = result.getFile();
            } else {
                File file;
                ProtectionDomain pd = DirectLoader.class.getProtectionDomain();
                CodeSource cs = pd.getCodeSource();
                if (cs != null && (file = new File(cs.getLocation().toURI())).isAbsolute() && file.exists()) {
                    classPath = file;
                }
            }
            if (classPath == null) {
                log.error("Could not find classpath for loader");
                return;
            }
            StringBuilder cmd = new StringBuilder();
            cmd.append(System.getProperty("java.home")).append(File.separatorChar).append("bin").append(File.separatorChar);
            if (ExternalLoader.isWindows()) {
                cmd.append("java.exe");
            } else {
                cmd.append("java");
            }
            ProcessBuilder procBuilder = new ProcessBuilder(ExternalLoader.quote(cmd.toString()), "-cp", ExternalLoader.quote(classPath.getAbsolutePath()), DirectLoader.class.getName(), ExternalLoader.quote(jarFilePath), ExternalLoader.quote(pid), ExternalLoader.quote(params));
            procBuilder.redirectErrorStream(true);
            Process proc = procBuilder.start();
            try (InputStream is = proc.getInputStream();){
                if (proc.waitFor() == 42) {
                    log.info("External attach was successful");
                } else {
                    byte[] buf = new byte[4096];
                    int i = is.read(buf);
                    log.error("External attach faileld: {}, cmd: {}", (Object)(i == -1 ? "(no more info)" : new String(buf, 0, i)), procBuilder.command());
                }
            }
        }
    }
}

