/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.datasource.pool;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.avaje.datasource.PoolStatistics;
import org.avaje.datasource.PoolStatus;
import org.avaje.datasource.pool.BusyConnectionBuffer;
import org.avaje.datasource.pool.ConnectionPool;
import org.avaje.datasource.pool.DataSourcePoolStatistics;
import org.avaje.datasource.pool.FreeConnectionBuffer;
import org.avaje.datasource.pool.PooledConnection;
import org.avaje.datasource.pool.PooledConnectionStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnectionQueue {
    private static final Logger logger = LoggerFactory.getLogger(PooledConnectionQueue.class);
    private static final TimeUnit MILLIS_TIME_UNIT = TimeUnit.MILLISECONDS;
    private final String name;
    private final ConnectionPool pool;
    private final FreeConnectionBuffer freeList;
    private final BusyConnectionBuffer busyList;
    private final PooledConnectionStatistics collectedStats = new PooledConnectionStatistics();
    private PooledConnectionStatistics.LoadValues accumulatedValues = new PooledConnectionStatistics.LoadValues();
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private int connectionId;
    private final long waitTimeoutMillis;
    private final long leakTimeMinutes;
    private final long maxAgeMillis;
    private int warningSize;
    private int maxSize;
    private int minSize;
    private int waitingThreads;
    private int waitCount;
    private int hitCount;
    private int highWaterMark;
    private long lastResetTime;
    private boolean doingShutdown;

    PooledConnectionQueue(ConnectionPool pool) {
        this.pool = pool;
        this.name = pool.getName();
        this.minSize = pool.getMinSize();
        this.maxSize = pool.getMaxSize();
        this.warningSize = pool.getWarningSize();
        this.waitTimeoutMillis = pool.getWaitTimeoutMillis();
        this.leakTimeMinutes = pool.getLeakTimeMinutes();
        this.maxAgeMillis = pool.getMaxAgeMillis();
        this.busyList = new BusyConnectionBuffer(this.maxSize, 20);
        this.freeList = new FreeConnectionBuffer();
        this.lock = new ReentrantLock(false);
        this.notEmpty = this.lock.newCondition();
    }

    private PoolStatus createStatus() {
        return new ConnectionPool.Status(this.minSize, this.maxSize, this.freeList.size(), this.busyList.size(), this.waitingThreads, this.highWaterMark, this.waitCount, this.hitCount);
    }

    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            String string = this.createStatus().toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    void reportClosingConnection(PooledConnection pooledConnection) {
        this.collectedStats.add(pooledConnection.getStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolStatistics getStatistics(boolean reset) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            PooledConnectionStatistics.LoadValues aggregate = this.collectedStats.getValues(reset);
            this.freeList.collectStatistics(aggregate, reset);
            this.busyList.collectStatistics(aggregate, reset);
            aggregate.plus(this.accumulatedValues);
            this.accumulatedValues = reset ? new PooledConnectionStatistics.LoadValues() : aggregate;
            DataSourcePoolStatistics dataSourcePoolStatistics = new DataSourcePoolStatistics(aggregate.getCollectionStart(), aggregate.getCount(), aggregate.getErrorCount(), aggregate.getHwmMicros(), aggregate.getTotalMicros());
            return dataSourcePoolStatistics;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolStatus getStatus(boolean reset) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            PoolStatus s = this.createStatus();
            if (reset) {
                this.highWaterMark = this.busyList.size();
                this.hitCount = 0;
                this.waitCount = 0;
            }
            PoolStatus poolStatus = s;
            return poolStatus;
        }
        finally {
            lock.unlock();
        }
    }

    void setMinSize(int minSize) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (minSize > this.maxSize) {
                throw new IllegalArgumentException("minSize " + minSize + " > maxSize " + this.maxSize);
            }
            this.minSize = minSize;
        }
        finally {
            lock.unlock();
        }
    }

    void setMaxSize(int maxSize) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (maxSize < this.minSize) {
                throw new IllegalArgumentException("maxSize " + maxSize + " < minSize " + this.minSize);
            }
            this.busyList.setCapacity(maxSize);
            this.maxSize = maxSize;
        }
        finally {
            lock.unlock();
        }
    }

    void setWarningSize(int warningSize) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (warningSize > this.maxSize) {
                throw new IllegalArgumentException("warningSize " + warningSize + " > maxSize " + this.maxSize);
            }
            this.warningSize = warningSize;
        }
        finally {
            lock.unlock();
        }
    }

    private int totalConnections() {
        return this.freeList.size() + this.busyList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureMinimumConnections() throws SQLException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int add = this.minSize - this.totalConnections();
            if (add > 0) {
                for (int i = 0; i < add; ++i) {
                    PooledConnection c = this.pool.createConnectionForQueue(this.connectionId++);
                    this.freeList.add(c);
                }
                this.notEmpty.signal();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnPooledConnection(PooledConnection c, boolean forceClose) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (!this.busyList.remove(c)) {
                logger.error("Connection [{}] not found in BusyList? ", (Object)c);
            }
            if (forceClose || c.shouldTrimOnReturn(this.lastResetTime, this.maxAgeMillis)) {
                c.closeConnectionFully(false);
            } else {
                this.freeList.add(c);
                this.notEmpty.signal();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private PooledConnection extractFromFreeList() {
        PooledConnection c = this.freeList.remove();
        this.registerBusyConnection(c);
        return c;
    }

    PooledConnection getPooledConnection() throws SQLException {
        try {
            PooledConnection pc = this._getPooledConnection();
            pc.resetForUse();
            return pc;
        }
        catch (InterruptedException e) {
            String msg = "Interrupted getting connection from pool " + e;
            throw new SQLException(msg);
        }
    }

    private int registerBusyConnection(PooledConnection c) {
        int busySize = this.busyList.add(c);
        if (busySize > this.highWaterMark) {
            this.highWaterMark = busySize;
        }
        return busySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledConnection _getPooledConnection() throws InterruptedException, SQLException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            if (this.doingShutdown) {
                throw new SQLException("Trying to access the Connection Pool when it is shutting down");
            }
            ++this.hitCount;
            if (this.waitingThreads == 0) {
                if (!this.freeList.isEmpty()) {
                    PooledConnection pooledConnection = this.extractFromFreeList();
                    return pooledConnection;
                }
                if (this.busyList.size() < this.maxSize) {
                    PooledConnection c = this.pool.createConnectionForQueue(this.connectionId++);
                    int busySize = this.registerBusyConnection(c);
                    if (logger.isDebugEnabled()) {
                        logger.debug("DataSourcePool [{}] grow; id[{}] busy[{}] max[{}]", new Object[]{this.name, c.getName(), busySize, this.maxSize});
                    }
                    this.checkForWarningSize();
                    PooledConnection pooledConnection = c;
                    return pooledConnection;
                }
            }
            try {
                ++this.waitCount;
                ++this.waitingThreads;
                PooledConnection pooledConnection = this._getPooledConnectionWaitLoop();
                --this.waitingThreads;
                return pooledConnection;
            }
            catch (Throwable throwable) {
                --this.waitingThreads;
                throw throwable;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    private PooledConnection _getPooledConnectionWaitLoop() throws SQLException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.doingShutdown = true;
            PoolStatus status = this.createStatus();
            PoolStatistics statistics = this.pool.getStatistics(false);
            logger.debug("DataSourcePool [{}] shutdown {} - Statistics {}", new Object[]{this.name, status, statistics});
            this.closeFreeConnections(true);
            if (!this.busyList.isEmpty()) {
                logger.warn("Closing busy connections on shutdown size: " + this.busyList.size());
                this.dumpBusyConnectionInformation();
                this.closeBusyConnections(0L);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(long leakTimeMinutes) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            PoolStatus status = this.createStatus();
            logger.info("Reseting DataSourcePool [{}] {}", (Object)this.name, (Object)status);
            this.lastResetTime = System.currentTimeMillis();
            this.closeFreeConnections(false);
            this.closeBusyConnections(leakTimeMinutes);
            logger.info("Busy Connections:\n" + this.getBusyConnectionInformation());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim(long maxInactiveMillis, long maxAgeMillis) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.trimInactiveConnections(maxInactiveMillis, maxAgeMillis) > 0) {
                try {
                    this.ensureMinimumConnections();
                }
                catch (SQLException e) {
                    logger.error("Error trying to ensure minimum connections", (Throwable)e);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private int trimInactiveConnections(long maxInactiveMillis, long maxAgeMillis) {
        long createdSince;
        long usedSince = System.currentTimeMillis() - maxInactiveMillis;
        int trimedCount = this.freeList.trim(usedSince, createdSince = maxAgeMillis == 0L ? 0L : System.currentTimeMillis() - maxAgeMillis);
        if (trimedCount > 0) {
            logger.debug("DataSourcePool [{}] trimmed [{}] inactive connections. New size[{}]", new Object[]{this.name, trimedCount, this.totalConnections()});
        }
        return trimedCount;
    }

    private void closeFreeConnections(boolean logErrors) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.freeList.closeAll(logErrors);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeBusyConnections(long leakTimeMinutes) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.busyList.closeBusyConnections(leakTimeMinutes);
        }
        finally {
            lock.unlock();
        }
    }

    private void checkForWarningSize() {
        int availableGrowth = this.maxSize - this.totalConnections();
        if (availableGrowth < this.warningSize) {
            this.closeBusyConnections(this.leakTimeMinutes);
            String msg = "DataSourcePool [" + this.name + "] is [" + availableGrowth + "] connections from its maximum size.";
            this.pool.notifyWarning(msg);
        }
    }

    String getBusyConnectionInformation() {
        return this.getBusyConnectionInformation(false);
    }

    void dumpBusyConnectionInformation() {
        this.getBusyConnectionInformation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBusyConnectionInformation(boolean toLogger) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            String string = this.busyList.getBusyConnectionInformation(toLogger);
            return string;
        }
        finally {
            lock.unlock();
        }
    }
}

