/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.dbmigration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.avaje.dbmigration.MigrationException;

public class MigrationConfig {
    private String migrationPath = "dbmigration";
    private String metaTable = "db_migration";
    private String applySuffix = ".sql";
    private String runPlaceholders;
    private Map<String, String> runPlaceholderMap;
    private ClassLoader classLoader;
    private String dbUsername;
    private String dbPassword;
    private String dbDriver;
    private String dbUrl;
    private String dbSchema;
    private boolean createSchemaIfNotExists;

    public String getMetaTable() {
        return this.metaTable;
    }

    public void setMetaTable(String metaTable) {
        this.metaTable = metaTable;
    }

    public String getRunPlaceholders() {
        return this.runPlaceholders;
    }

    public void setRunPlaceholders(String runPlaceholders) {
        this.runPlaceholders = runPlaceholders;
    }

    public Map<String, String> getRunPlaceholderMap() {
        return this.runPlaceholderMap;
    }

    public void setRunPlaceholderMap(Map<String, String> runPlaceholderMap) {
        this.runPlaceholderMap = runPlaceholderMap;
    }

    public String getMigrationPath() {
        return this.migrationPath;
    }

    public void setMigrationPath(String migrationPath) {
        this.migrationPath = migrationPath;
    }

    public String getApplySuffix() {
        return this.applySuffix;
    }

    public void setApplySuffix(String applySuffix) {
        this.applySuffix = applySuffix;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public boolean isCreateSchemaIfNotExists() {
        return this.createSchemaIfNotExists;
    }

    public void setCreateSchemaIfNotExists(boolean createSchemaIfNotExists) {
        this.createSchemaIfNotExists = createSchemaIfNotExists;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void load(Properties props) {
        this.dbUsername = props.getProperty("dbmigration.username", this.dbUsername);
        this.dbPassword = props.getProperty("dbmigration.password", this.dbPassword);
        this.dbDriver = props.getProperty("dbmigration.driver", this.dbDriver);
        this.dbUrl = props.getProperty("dbmigration.url", this.dbUrl);
        this.applySuffix = props.getProperty("dbmigration.applySuffix", this.applySuffix);
        this.metaTable = props.getProperty("dbmigration.metaTable", this.metaTable);
        this.migrationPath = props.getProperty("dbmigration.migrationPath", this.migrationPath);
        this.runPlaceholders = props.getProperty("dbmigration.placeholders", this.runPlaceholders);
    }

    public Connection createConnection() {
        if (this.dbUsername == null) {
            throw new MigrationException("Database username is null?");
        }
        if (this.dbPassword == null) {
            throw new MigrationException("Database password is null?");
        }
        if (this.dbDriver == null) {
            throw new MigrationException("Database Driver is null?");
        }
        if (this.dbUrl == null) {
            throw new MigrationException("Database connection URL is null?");
        }
        this.loadDriver();
        try {
            Properties props = new Properties();
            props.setProperty("user", this.dbUsername);
            props.setProperty("password", this.dbPassword);
            return DriverManager.getConnection(this.dbUrl, props);
        }
        catch (SQLException e) {
            throw new MigrationException("Error trying to create Connection", e);
        }
    }

    private void loadDriver() {
        try {
            ClassLoader contextLoader = this.getClassLoader();
            Class.forName(this.dbDriver, true, contextLoader);
        }
        catch (Throwable e) {
            throw new MigrationException("Problem loading Database Driver [" + this.dbDriver + "]: " + e.getMessage(), e);
        }
    }
}

