/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.dbmigration;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.avaje.dbmigration.MigrationConfig;
import org.avaje.dbmigration.runner.LocalMigrationResource;
import org.avaje.dbmigration.runner.LocalMigrationResources;
import org.avaje.dbmigration.runner.MigrationSchema;
import org.avaje.dbmigration.runner.MigrationTable;
import org.avaje.dbmigration.util.JdbcClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationRunner {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.avaje.dbmigration.MigrationRunner");
    private final MigrationConfig migrationConfig;

    public MigrationRunner(MigrationConfig migrationConfig) {
        this.migrationConfig = migrationConfig;
    }

    public void run() {
        Connection connection = this.migrationConfig.createConnection();
        this.run(connection);
    }

    public void run(DataSource dataSource) {
        this.run(this.getConnection(dataSource));
    }

    private Connection getConnection(DataSource dataSource) {
        String username = this.migrationConfig.getDbUsername();
        try {
            if (username == null) {
                return dataSource.getConnection();
            }
            logger.debug("using db user [{}] to run migrations ...", (Object)username);
            return dataSource.getConnection(username, this.migrationConfig.getDbPassword());
        }
        catch (SQLException e) {
            String msgSuffix = username == null ? "" : " using user [" + username + "]";
            throw new IllegalArgumentException("Error trying to connect to database for DB Migration" + msgSuffix, e);
        }
    }

    public void run(Connection connection) {
        LocalMigrationResources resources = new LocalMigrationResources(this.migrationConfig);
        if (!resources.readResources()) {
            logger.debug("no migrations to check");
            return;
        }
        try {
            connection.setAutoCommit(false);
            MigrationSchema schema = new MigrationSchema(this.migrationConfig, connection);
            schema.createAndSetIfNeeded();
            this.runMigrations(resources, connection);
            connection.commit();
        }
        catch (Exception e) {
            JdbcClose.rollback(connection);
            throw new RuntimeException(e);
        }
        finally {
            JdbcClose.close(connection);
        }
    }

    private void runMigrations(LocalMigrationResources resources, Connection connection) throws SQLException, IOException {
        LocalMigrationResource localVersion;
        MigrationTable table = new MigrationTable(this.migrationConfig, connection);
        table.createIfNeeded();
        List<LocalMigrationResource> localVersions = resources.getVersions();
        logger.info("local migrations:{}  existing migrations:{}", (Object)localVersions.size(), (Object)table.size());
        LocalMigrationResource priorVersion = null;
        for (int i = 0; i < localVersions.size() && table.shouldRun(localVersion = localVersions.get(i), priorVersion); ++i) {
            priorVersion = localVersion;
            connection.commit();
        }
    }
}

