/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateExceptionHandler;

public class ConfigurationBuilder {
    private ObjectWrapper wrapper = ObjectWrapper.DEFAULT_WRAPPER;
    private String encoding = "UTF-8";
    private String numberFormat = "0.######";
    private boolean localizedLookup;
    private int templateUpdateDelay;
    private boolean useExceptionHandler;
    private TemplateLoader templateLoader;

    public Configuration build() {
        try {
            Configuration config = new Configuration();
            config.setObjectWrapper(this.wrapper);
            config.setLocalizedLookup(this.localizedLookup);
            config.setDefaultEncoding(this.encoding);
            config.setTemplateUpdateDelay(this.templateUpdateDelay);
            config.setNumberFormat(this.numberFormat);
            if (this.useExceptionHandler) {
                config.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
            }
            config.setTemplateLoader(this.templateLoader);
            return config;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectWrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(ObjectWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getTemplateUpdateDelay() {
        return this.templateUpdateDelay;
    }

    public void setTemplateUpdateDelay(int templateUpdateDelay) {
        this.templateUpdateDelay = templateUpdateDelay;
    }

    public boolean isUseExceptionHandler() {
        return this.useExceptionHandler;
    }

    public void setUseExceptionHandler(boolean useExceptionHandler) {
        this.useExceptionHandler = useExceptionHandler;
    }

    public boolean isLocalizedLookup() {
        return this.localizedLookup;
    }

    public void setLocalizedLookup(boolean localizedLookup) {
        this.localizedLookup = localizedLookup;
    }

    public TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    public void setTemplateLoader(TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }
}

