/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.freemarker.layout;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.avaje.freemarker.layout.Crumb;
import org.avaje.freemarker.layout.HeadVariableReader;
import org.avaje.freemarker.layout.StringHelper;
import org.avaje.freemarker.layout.Tags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeadContent
implements Tags {
    public static final HeadContent NONE = new HeadContent();
    private static final Logger log = LoggerFactory.getLogger(HeadContent.class);
    private static final String TAG_TITLE = "<title>";
    private static final String TAG_TITLE_END = "</title>";
    private static final String META_LAYOUT = "<meta name=\"layout\"";
    private static final String _END_TAG = ">";
    private static final String TAG_BREAD = "<meta name=\"bread";
    private static final String META_ID_LAYOUT_HEAD = "<meta id=\"layout-head\"";
    private List<String> lines = new ArrayList<String>();
    private Map<String, String> variables = new LinkedHashMap<String, String>();
    private Map<String, Crumb> bread = new LinkedHashMap<String, Crumb>();
    private final String templateName;
    private final int headStart;
    private String content;
    private String title;
    private String parentLayout;
    private int metaAddPosition = -1;

    private HeadContent() {
        this.headStart = -1;
        this.templateName = "";
    }

    public HeadContent(String content, int headStart, String templateName) {
        this.headStart = headStart;
        this.content = content;
        this.templateName = templateName;
        this.parseMetaContent();
        this.parseLines();
    }

    public int start() {
        return this.headStart;
    }

    public void render(StringBuilder sb) {
        sb.append("\n<head>\n");
        if (this.title != null) {
            sb.append(String.format("  <title>%s</title>\n", this.title));
        }
        for (String line : this.lines) {
            if (line.trim().isEmpty()) continue;
            sb.append(line).append("\n");
        }
        sb.append("</head>\n");
    }

    static HeadContent parse(String templateName, String originalContent) {
        int headStart = originalContent.indexOf("<head>");
        if (headStart == -1) {
            return NONE;
        }
        int headEnd = originalContent.indexOf("</head>", headStart + "<head>".length());
        if (headEnd == -1) {
            throw new RuntimeException("'</head>' tag not found in template[" + templateName + "] after position [" + headStart + "]");
        }
        return new HeadContent(originalContent.substring(headStart + 6, headEnd), headStart, templateName);
    }

    boolean hasParentLayout() {
        return this.parentLayout != null;
    }

    String getParentLayout() {
        return this.parentLayout;
    }

    private void parseLines() {
        LineNumberReader lineReader = new LineNumberReader(new StringReader(this.content));
        try {
            String line;
            while ((line = lineReader.readLine()) != null) {
                this.addLine(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addLine(String line) {
        boolean consumed;
        boolean bl = consumed = this.readTitle(line) || this.readParentLayout(line) || this.readCrumb(line) || this.readMetaLayout(line);
        if (!consumed) {
            this.lines.add(line);
        }
    }

    private boolean readMetaLayout(String line) {
        if (!line.contains(META_ID_LAYOUT_HEAD)) {
            return false;
        }
        this.metaAddPosition = this.lines.size();
        return true;
    }

    boolean readParentLayout(String line) {
        int tnStart;
        int pos = line.indexOf(META_LAYOUT);
        if (pos == -1) {
            return false;
        }
        int end = line.lastIndexOf(_END_TAG);
        if (end == -1) {
            throw new RuntimeException("'>' not found for <meta name=\"content\" in line [" + line + "]");
        }
        if (this.parentLayout != null) {
            log.error("Duplicate meta layout in page " + this.templateName);
        }
        if ((tnStart = line.indexOf("content=", pos)) == -1) {
            throw new RuntimeException("No 'content=' attribute in <meta name=\"layout\" ... element?");
        }
        String layout = line.substring(tnStart + 8, end);
        if (layout.endsWith("/")) {
            layout = layout.substring(0, layout.length() - 1);
        }
        this.parentLayout = StringHelper.removeChars(layout, new char[]{'\"', '\''}).trim();
        return true;
    }

    private boolean readTitle(String line) {
        if (this.title != null) {
            return false;
        }
        int pos = line.indexOf(TAG_TITLE);
        if (pos == -1) {
            return false;
        }
        int end = line.lastIndexOf(TAG_TITLE_END);
        this.title = line.substring(pos + TAG_TITLE.length(), end);
        return true;
    }

    private boolean readCrumb(String line) {
        int pos = line.indexOf(TAG_BREAD);
        if (pos == -1) {
            return false;
        }
        int end = line.lastIndexOf("/>");
        if (end == -1) {
            throw new RuntimeException("'/>' not found in line [" + line + "]");
        }
        String breadContent = line.substring(pos, end);
        String name = this.getAttribute("name", breadContent);
        String desc = this.getAttribute("content", breadContent);
        String href = this.getAttribute("href", breadContent);
        Crumb crumb = new Crumb(name, desc, href);
        this.bread.putIfAbsent(name, crumb);
        return true;
    }

    private void parseMetaContent() {
        this.parseVariables();
    }

    private void parseVariables() {
        this.content = HeadVariableReader.readAll(this.content, this.variables);
    }

    private String getAttribute(String attribute, String breadContent) {
        String attr = attribute + "=\"";
        int start = breadContent.indexOf(attr);
        int end = breadContent.indexOf("\"", start + attr.length() + 1);
        return breadContent.substring(start + attr.length(), end);
    }

    void mergeWith(HeadContent child) {
        this.variables.putAll(child.variables);
        this.bread.putAll(child.bread);
        if (child.title != null) {
            this.title = child.title;
        }
        if (this.metaAddPosition == -1) {
            this.lines.addAll(child.lines);
        } else {
            this.lines.addAll(this.metaAddPosition, child.lines);
        }
    }

    String replaceVariables(String pageContent) {
        if (this.variables.isEmpty()) {
            return pageContent;
        }
        for (Map.Entry<String, String> entry : this.variables.entrySet()) {
            String varId = entry.getKey();
            String varContent = entry.getValue();
            pageContent = StringHelper.replaceString(pageContent, "$" + varId, varContent);
        }
        return pageContent;
    }

    String replaceBreadCrumbs(String pageContent) {
        if (this.bread.isEmpty()) {
            return StringHelper.replaceString(pageContent, "$breadcrumb", "");
        }
        int size = this.bread.size();
        StringBuilder crumbs = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            Crumb crumb = this.bread.get("bread" + i);
            if (crumb == null) continue;
            boolean withLink = i < size - 1;
            String crumbContent = crumb.render(withLink);
            if (i > 0) {
                crumbs.append("<span class=\"sep\">&nbsp;/&nbsp;</span>");
            }
            crumbs.append(crumbContent);
        }
        return StringHelper.replaceString(pageContent, "$breadcrumb", crumbs.toString());
    }
}

