/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.freemarker.layout;

import java.util.Map;

class HeadVariableReader {
    private final Map<String, String> variables;
    private String content;
    private int start;
    private String elementStart = "<template id=\"";
    private String elementEnd = "</template>";

    static String readAll(String content, Map<String, String> variables) {
        return new HeadVariableReader(content, variables).read();
    }

    HeadVariableReader(String content, Map<String, String> variables) {
        this.variables = variables;
        this.content = content;
    }

    private void readUsingVarVariables() {
        this.elementStart = "<var id=\"";
        this.elementEnd = "</var>";
        this.readVariables();
    }

    private void readPositions() {
        this.start = this.content.indexOf(this.elementStart);
    }

    String read() {
        this.readVariables();
        this.readUsingVarVariables();
        return this.content;
    }

    void readVariables() {
        this.readPositions();
        while (this.start > -1) {
            this.readVariable(this.start);
            this.readPositions();
        }
    }

    private void readVariable(int start) {
        int pos = this.content.indexOf("\">", start + this.elementStart.length());
        if (pos == -1) {
            throw new RuntimeException("No closing '\">' reading meta variable at pos[" + start + "]");
        }
        int end = this.content.indexOf(this.elementEnd, pos);
        if (end == -1) {
            throw new RuntimeException(this.elementEnd + " not found reading meta variable at pos[" + pos + "]");
        }
        String varId = this.content.substring(start + this.elementStart.length(), pos).trim();
        String varContent = this.content.substring(pos + 2, end).trim();
        this.variables.putIfAbsent(varId, varContent);
        this.content = this.content.substring(0, start) + this.content.substring(end + this.elementEnd.length());
    }
}

