/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.freemarker.layout;

import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.ServletContext;
import org.avaje.freemarker.layout.ContentFilter;
import org.avaje.freemarker.layout.RawTemplateInherit;
import org.avaje.freemarker.layout.RawTemplateSource;
import org.avaje.freemarker.util.IOUtil;

public final class InheritLayoutTemplateLoader
implements TemplateLoader {
    private final TemplateLoader wrapped;
    private final RawTemplateInherit inheritHandler;

    public static TemplateLoader createWebappLoader(ServletContext servletContext, String templatePath) {
        return InheritLayoutTemplateLoader.createWebappLoader(servletContext, templatePath, null);
    }

    public static TemplateLoader createWebappLoader(ServletContext servletContext, String templatePath, ContentFilter contentFilter) {
        return InheritLayoutTemplateLoader.wrap((TemplateLoader)new WebappTemplateLoader(servletContext, templatePath), contentFilter);
    }

    public static TemplateLoader wrap(TemplateLoader baseLoader, ContentFilter contentFilter) {
        return new InheritLayoutTemplateLoader(baseLoader, contentFilter);
    }

    public InheritLayoutTemplateLoader(TemplateLoader wrapped, ContentFilter contentFilter) {
        this.wrapped = wrapped;
        this.inheritHandler = new RawTemplateInherit(new Source(wrapped), contentFilter);
    }

    public Object findTemplateSource(String name) throws IOException {
        Object o = this.wrapped.findTemplateSource(name);
        if (o == null) {
            return null;
        }
        return new SourceWrapper(name, o);
    }

    public long getLastModified(Object templateSource) {
        return this.wrapped.getLastModified(((SourceWrapper)templateSource).wrappedSource);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        this.wrapped.closeTemplateSource(((SourceWrapper)templateSource).wrappedSource);
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return this.inheritHandler.getReader(((SourceWrapper)templateSource).templateName, encoding);
    }

    private static class Source
    implements RawTemplateSource {
        private final TemplateLoader wrapped;

        Source(TemplateLoader wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public String getSource(String templateName, String encoding) throws IOException {
            try {
                Object s = this.wrapped.findTemplateSource(templateName);
                Reader reader = this.wrapped.getReader(s, encoding);
                return IOUtil.read(reader);
            }
            catch (Exception e) {
                throw new IOException("Error loading source for template: " + templateName, e);
            }
        }
    }

    private static final class SourceWrapper {
        final String templateName;
        final Object wrappedSource;

        private SourceWrapper(String templateName, Object wrappedSource) {
            this.templateName = templateName;
            this.wrappedSource = wrappedSource;
        }
    }
}

