/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.freemarker.layout;

import org.avaje.freemarker.layout.BodyContent;
import org.avaje.freemarker.layout.HeadContent;

class PageContent {
    private final String templateName;
    private final String originalContent;
    private HeadContent headContent;
    private BodyContent bodyContent;

    PageContent(String templateName, String originalContent) {
        this.templateName = templateName;
        this.originalContent = originalContent;
        this.parse();
    }

    boolean hasParentLayout() {
        return this.headContent != null && this.headContent.hasParentLayout();
    }

    public String getParentLayout() {
        return this.headContent.getParentLayout();
    }

    private void parse() {
        this.bodyContent = BodyContent.parse(this.templateName, this.originalContent);
        this.headContent = HeadContent.parse(this.templateName, this.originalContent);
    }

    String renderContent() {
        String pageContent = this.baseRender();
        pageContent = this.headContent.replaceVariables(pageContent);
        pageContent = this.headContent.replaceBreadCrumbs(pageContent);
        return pageContent;
    }

    private String baseRender() {
        StringBuilder sb = new StringBuilder(this.originalContent.length() + 512);
        int headStart = this.headContent.start();
        if (headStart > -1) {
            sb.append(this.originalContent.substring(0, headStart).trim());
            this.headContent.render(sb);
        }
        this.bodyContent.render(sb);
        return sb.toString();
    }

    void mergeChild(PageContent child) {
        this.headContent.mergeWith(child.headContent);
        this.bodyContent.mergeWith(child.bodyContent);
    }
}

