/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.freemarker.layout;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.avaje.freemarker.layout.ContentFilter;
import org.avaje.freemarker.layout.PageContent;
import org.avaje.freemarker.layout.RawTemplateSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RawTemplateInherit {
    private static final Logger log = LoggerFactory.getLogger(RawTemplateInherit.class);
    private final RawTemplateSource templateSource;
    private final ContentFilter contentFilter;

    RawTemplateInherit(RawTemplateSource templateSource, ContentFilter contentFilter) {
        this.templateSource = templateSource;
        this.contentFilter = contentFilter;
    }

    public Reader getReader(String templateName, String encoding) throws IOException {
        return new StringReader(this.getSource(templateName, encoding));
    }

    String getSource(String templateName, String encoding) throws IOException {
        String baseContent = this.templateSource.getSource(templateName, encoding);
        if (baseContent == null) {
            throw new RuntimeException("template not found: " + templateName);
        }
        PageContent page = new PageContent(templateName, baseContent);
        String result = this.mergeInheritedLayout(encoding, page);
        if (this.contentFilter != null) {
            return this.contentFilter.filter(result);
        }
        return result;
    }

    private String mergeInheritedLayout(String encoding, PageContent page) throws IOException {
        if (!page.hasParentLayout()) {
            return page.renderContent();
        }
        return this.mergeContent(encoding, page);
    }

    private String mergeContent(String encoding, PageContent page) throws IOException {
        String parentLayout = page.getParentLayout();
        log.trace("merge parentLayout {}", (Object)parentLayout);
        String parentContent = this.templateSource.getSource(parentLayout, encoding);
        PageContent parentPage = new PageContent(parentLayout, parentContent);
        parentPage.mergeChild(page);
        return this.mergeInheritedLayout(encoding, parentPage);
    }
}

