/*
 * Decompiled with CFR 0.152.
 */
package jakarta.json.spi;

import jakarta.json.JsonException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public abstract class JsonProvider {
    private static final String JSONP_PROVIDER_FACTORY = "jakarta.json.provider";
    private static final String DEFAULT_PROVIDER = "org.eclipse.jsonp.JsonProviderImpl";
    private static final String OSGI_SERVICE_LOADER_CLASS_NAME = "org.glassfish.hk2.osgiresourcelocator.ServiceLoader";

    protected JsonProvider() {
    }

    public static JsonProvider provider() {
        JsonProvider result;
        if (LazyFactoryLoader.JSON_PROVIDER != null) {
            return JsonProvider.newInstance(LazyFactoryLoader.JSON_PROVIDER);
        }
        ServiceLoader<JsonProvider> loader = ServiceLoader.load(JsonProvider.class);
        Iterator<JsonProvider> it = loader.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        if (JsonProvider.isOsgi() && (result = JsonProvider.lookupUsingOSGiServiceLoader(JsonProvider.class)) != null) {
            return result;
        }
        try {
            Class<?> clazz = Class.forName(DEFAULT_PROVIDER);
            return (JsonProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw new JsonException("Provider org.eclipse.jsonp.JsonProviderImpl not found", x);
        }
        catch (Exception x) {
            throw new JsonException("Provider org.eclipse.jsonp.JsonProviderImpl could not be instantiated: " + x, x);
        }
    }

    private static JsonProvider newInstance(Class<? extends JsonProvider> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unable to create " + clazz.getName(), e);
        }
    }

    public abstract JsonGenerator.Key createGeneratorKey(String var1);

    public abstract JsonParser createParser(Reader var1);

    public abstract JsonParser createParser(InputStream var1);

    public abstract JsonParserFactory createParserFactory(Map<String, ?> var1);

    public abstract JsonGenerator createGenerator(Writer var1);

    public abstract JsonGenerator createGenerator(OutputStream var1);

    public abstract JsonGeneratorFactory createGeneratorFactory(Map<String, ?> var1);

    private static boolean isOsgi() {
        try {
            Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static <T> T lookupUsingOSGiServiceLoader(Class<? extends T> serviceClass) {
        try {
            Class[] args = new Class[]{serviceClass};
            Class<?> target = Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            Method m = target.getMethod("lookupProviderInstances", Class.class);
            Iterator iter = ((Iterable)m.invoke(null, (Object[])args)).iterator();
            return iter.hasNext() ? (T)iter.next() : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static class LazyFactoryLoader {
        private static final Class<? extends JsonProvider> JSON_PROVIDER;

        private LazyFactoryLoader() {
        }

        static {
            String className = System.getProperty(JsonProvider.JSONP_PROVIDER_FACTORY);
            if (className != null) {
                try {
                    JSON_PROVIDER = Class.forName(className);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("Unable to create " + className, e);
                }
            } else {
                JSON_PROVIDER = null;
            }
        }
    }
}

