/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metrics.collectd;

import java.io.IOException;
import java.net.InetAddress;
import java.time.Clock;
import java.util.List;
import org.avaje.metric.report.MetricReporter;
import org.avaje.metric.report.ReportMetrics;
import org.avaje.metric.statistics.CounterStatistics;
import org.avaje.metric.statistics.GaugeDoubleStatistics;
import org.avaje.metric.statistics.GaugeLongStatistics;
import org.avaje.metric.statistics.MetricStatistics;
import org.avaje.metric.statistics.MetricStatisticsVisitor;
import org.avaje.metric.statistics.TimedStatistics;
import org.avaje.metric.statistics.ValueStatistics;
import org.avaje.metrics.collectd.MetaData;
import org.avaje.metrics.collectd.PacketWriter;
import org.avaje.metrics.collectd.SecurityLevel;
import org.avaje.metrics.collectd.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectdReporter
implements MetricReporter {
    private static final Logger log = LoggerFactory.getLogger(CollectdReporter.class);
    private static final String FALLBACK_HOST_NAME = "localhost";
    private final String hostName;
    private final Sender sender;
    private final PacketWriter writer;
    private final Clock clock;

    public static Builder create() {
        return new Builder();
    }

    private CollectdReporter(String hostname, Sender sender, String username, String password, SecurityLevel securityLevel, Clock clock) {
        this.clock = clock;
        this.sender = sender;
        this.hostName = hostname != null ? hostname : this.resolveHostName();
        this.writer = new PacketWriter(sender, username, password, securityLevel);
    }

    private String resolveHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            log.error("Failed to lookup local host name: {}", (Object)e.getMessage(), (Object)e);
            return FALLBACK_HOST_NAME;
        }
    }

    public void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(ReportMetrics reportMetrics) {
        log.debug("reporting metrics ...");
        long epochSecs = this.clock.millis() / 1000L;
        MetaData metaData = new MetaData(this.hostName, epochSecs, reportMetrics.getFreqInSeconds());
        try {
            this.connect(this.sender);
            List metrics = reportMetrics.getMetrics();
            Adapter adapter = new Adapter(this, metaData);
            for (MetricStatistics metric : metrics) {
                metric.visit((MetricStatisticsVisitor)adapter);
            }
        }
        catch (Exception e) {
            log.warn("Error trying to send metrics to Collectd", (Throwable)e);
        }
        finally {
            this.disconnect(this.sender);
        }
    }

    private void reportGauge(MetaData metaData, GaugeLongStatistics metric) {
        metaData.plugin(metric.getName());
        this.write(metaData.typeInstance("value"), metric.getValue());
    }

    private void reportGauge(MetaData metaData, GaugeDoubleStatistics metric) {
        metaData.plugin(metric.getName());
        this.write(metaData.typeInstance("value"), metric.getValue());
    }

    private void reportCounter(MetaData metaData, CounterStatistics metric) {
        metaData.plugin(metric.getName());
        this.write(metaData.typeInstance("count"), metric.getCount());
    }

    private void reportTimed(MetaData metaData, TimedStatistics metric) {
        this.reportValues(metaData, (ValueStatistics)metric);
    }

    private void reportValues(MetaData metaData, ValueStatistics metric) {
        metaData.plugin(metric.getName());
        this.write(metaData.typeInstance("count"), metric.getCount());
        this.write(metaData.typeInstance("max"), metric.getMax());
        this.write(metaData.typeInstance("mean"), metric.getMean());
        this.write(metaData.typeInstance("total"), metric.getTotal());
    }

    private void connect(Sender sender) throws IOException {
        if (!sender.isConnected()) {
            sender.connect();
        }
    }

    private void disconnect(Sender sender) {
        try {
            sender.disconnect();
        }
        catch (Exception e) {
            log.warn("Error disconnecting from Collectd", (Throwable)e);
        }
    }

    private void write(MetaData metaData, Number ... values) {
        try {
            this.writer.write(metaData, values);
        }
        catch (RuntimeException e) {
            log.warn("Failed to process metric '" + metaData.getPlugin() + "': " + e.getMessage());
        }
        catch (IOException e) {
            log.error("Failed to send metric to collectd", (Throwable)e);
        }
    }

    private static class Adapter
    implements MetricStatisticsVisitor {
        private final CollectdReporter reporter;
        private final MetaData metaData;

        Adapter(CollectdReporter reporter, MetaData metaData) {
            this.reporter = reporter;
            this.metaData = metaData;
        }

        public void visit(TimedStatistics metric) {
            this.reporter.reportTimed(this.metaData, metric);
        }

        public void visit(ValueStatistics metric) {
            this.reporter.reportValues(this.metaData, metric);
        }

        public void visit(CounterStatistics metric) {
            this.reporter.reportCounter(this.metaData, metric);
        }

        public void visit(GaugeDoubleStatistics metric) {
            this.reporter.reportGauge(this.metaData, metric);
        }

        public void visit(GaugeLongStatistics metric) {
            this.reporter.reportGauge(this.metaData, metric);
        }
    }

    public static class Builder {
        private String collectdHost;
        private int collectdPort = 25826;
        private String sourceHost;
        private SecurityLevel securityLevel = SecurityLevel.NONE;
        private String username = "";
        private String password = "";
        private Clock clock = Clock.systemDefaultZone();

        private Builder() {
        }

        public Builder withCollectdHost(String host) {
            this.collectdHost = host;
            return this;
        }

        public Builder withCollectdPort(int port) {
            this.collectdPort = port;
            return this;
        }

        public Builder withHost(String hostName) {
            this.sourceHost = hostName;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withSecurityLevel(SecurityLevel securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        public CollectdReporter build() {
            if (this.securityLevel != SecurityLevel.NONE) {
                if (this.username.isEmpty()) {
                    throw new IllegalArgumentException("username is required for securityLevel: " + (Object)((Object)this.securityLevel));
                }
                if (this.password.isEmpty()) {
                    throw new IllegalArgumentException("password is required for securityLevel: " + (Object)((Object)this.securityLevel));
                }
            }
            Sender sender = new Sender(this.collectdHost, this.collectdPort);
            return new CollectdReporter(this.sourceHost, sender, this.username, this.password, this.securityLevel, this.clock);
        }
    }
}

