/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metrics.collectd;

import org.avaje.metrics.collectd.Sanitize;

class MetaData {
    private static final String COLLECTD_TYPE_GAUGE = "gauge";
    private final String host;
    private final long timestamp;
    private final long period;
    private String plugin;
    private String pluginInstance;
    private String type = "gauge";
    private String typeInstance;

    MetaData(String host, long epochSecs, long period) {
        this.host = host;
        this.timestamp = epochSecs;
        this.period = period;
    }

    String getHost() {
        return this.host;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    long getPeriod() {
        return this.period;
    }

    String getPlugin() {
        return this.plugin;
    }

    String getPluginInstance() {
        return this.pluginInstance;
    }

    String getType() {
        return this.type;
    }

    String getTypeInstance() {
        return this.typeInstance;
    }

    MetaData plugin(String name) {
        this.plugin = Sanitize.name(name);
        return this;
    }

    MetaData pluginInstance(String name) {
        this.pluginInstance = Sanitize.instanceName(name);
        return this;
    }

    MetaData type(String name) {
        this.type = Sanitize.name(name);
        return this;
    }

    MetaData typeInstance(String name) {
        this.typeInstance = name;
        return this;
    }
}

