/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.metrics.collectd;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

class Sender {
    private final String host;
    private final int port;
    private InetSocketAddress address;
    private DatagramChannel channel;

    Sender(String host, int port) {
        this.host = host;
        this.port = port;
    }

    void connect() throws IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        if (this.host != null) {
            this.address = new InetSocketAddress(this.host, this.port);
        }
        this.channel = DatagramChannel.open();
    }

    boolean isConnected() {
        return this.channel != null && !this.channel.socket().isClosed();
    }

    void send(ByteBuffer buffer) throws IOException {
        this.channel.send(buffer, this.address);
    }

    void disconnect() throws IOException {
        if (this.channel == null) {
            return;
        }
        try {
            this.channel.close();
        }
        finally {
            this.channel = null;
        }
    }
}

