/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.proxy.internal;

import java.lang.reflect.Method;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.awaitility.proxy.internal.ByteBuddyProxyCreator;
import org.awaitility.proxy.internal.TypeUtils;

public class MethodCallRecorder {
    private static final String NO_METHOD_CALL_RECORDED_MESSAGE = "No method call has been recorded. Perhaps the method was final?";
    private static final ThreadLocal<Object> lastTarget = new ThreadLocal();
    private static final ThreadLocal<Method> lastMethod = new ThreadLocal();
    private static final ThreadLocal<Object[]> lastArgs = new ThreadLocal();

    public static Object createProxy(Object target) {
        Object proxy = ByteBuddyProxyCreator.create(target.getClass(), MethodCallInterceptor.class);
        lastTarget.set(target);
        return proxy;
    }

    static Object getLastTarget() {
        Object target = lastTarget.get();
        if (target == null) {
            throw new IllegalStateException(NO_METHOD_CALL_RECORDED_MESSAGE);
        }
        return target;
    }

    static Method getLastMethod() {
        Method method = lastMethod.get();
        if (method == null) {
            throw new IllegalStateException(NO_METHOD_CALL_RECORDED_MESSAGE);
        }
        return method;
    }

    static Object[] getLastArgs() {
        Object target = lastTarget.get();
        if (target == null) {
            throw new IllegalStateException(NO_METHOD_CALL_RECORDED_MESSAGE);
        }
        return lastArgs.get();
    }

    static void reset() {
        lastTarget.remove();
        lastMethod.remove();
        lastArgs.remove();
    }

    public static class MethodCallInterceptor {
        @RuntimeType
        public static Object interceptExecutionDetails(@Origin Method method, @AllArguments Object[] args) {
            lastMethod.set(method);
            lastArgs.set(args);
            return TypeUtils.getDefaultValue(method.getReturnType());
        }
    }
}

