/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring.amqp;

import java.util.HashMap;
import java.util.Map;
import org.axonframework.contextsupport.spring.amqp.AMQPConfigurationBeanDefinitionParser;
import org.axonframework.eventhandling.amqp.spring.ListenerContainerLifecycleManager;
import org.axonframework.eventhandling.amqp.spring.SpringAMQPTerminal;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class TerminalBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String CONTAINER_MANAGER_SUFFIX = "$containerManager";
    private static final String DEFAULT_CONFIG_ELEMENT = "default-configuration";
    private static final String PROPERTY_CONTAINER_LIFECYCLE_MANAGER = "listenerContainerLifecycleManager";
    private static final String PROPERTY_DEFAULT_CONFIGURATION = "defaultConfiguration";
    private final BeanDefinitionParser configurationParser = new AMQPConfigurationBeanDefinitionParser();
    private static final Map<String, String> BEAN_REFERENCE_PROPERTIES = new HashMap<String, String>();
    private static final Map<String, String> BEAN_VALUE_PROPERTIES = new HashMap<String, String>();

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        GenericBeanDefinition terminalDefinition = new GenericBeanDefinition();
        terminalDefinition.setBeanClass(SpringAMQPTerminal.class);
        GenericBeanDefinition listenerContainerDefinition = this.createContainerManager(element, parserContext);
        String containerBeanName = this.resolveId(element, (AbstractBeanDefinition)terminalDefinition, parserContext) + CONTAINER_MANAGER_SUFFIX;
        terminalDefinition.getPropertyValues().add(PROPERTY_CONTAINER_LIFECYCLE_MANAGER, (Object)new RuntimeBeanReference(containerBeanName));
        MutablePropertyValues props = terminalDefinition.getPropertyValues();
        for (Map.Entry<String, String> entry : BEAN_REFERENCE_PROPERTIES.entrySet()) {
            if (!element.hasAttribute(entry.getKey())) continue;
            props.add(entry.getValue(), (Object)new RuntimeBeanReference(element.getAttribute(entry.getKey())));
        }
        for (Map.Entry<String, String> entry : BEAN_VALUE_PROPERTIES.entrySet()) {
            if (!element.hasAttribute(entry.getKey())) continue;
            props.add(entry.getValue(), (Object)element.getAttribute(entry.getKey()));
        }
        parserContext.getRegistry().registerBeanDefinition(containerBeanName, (BeanDefinition)listenerContainerDefinition);
        return terminalDefinition;
    }

    private GenericBeanDefinition createContainerManager(Element element, ParserContext parserContext) {
        Element defaultConfig;
        GenericBeanDefinition listenerContainerDefinition = new GenericBeanDefinition();
        listenerContainerDefinition.setBeanClass(ListenerContainerLifecycleManager.class);
        if (element.hasAttribute("connection-factory")) {
            listenerContainerDefinition.getPropertyValues().add("connectionFactory", (Object)new RuntimeBeanReference(element.getAttribute("connection-factory")));
        }
        if ((defaultConfig = DomUtils.getChildElementByTagName((Element)element, (String)DEFAULT_CONFIG_ELEMENT)) != null) {
            listenerContainerDefinition.getPropertyValues().add(PROPERTY_DEFAULT_CONFIGURATION, (Object)this.configurationParser.parse(defaultConfig, this.ctx(parserContext, listenerContainerDefinition)));
        }
        return listenerContainerDefinition;
    }

    private ParserContext ctx(ParserContext parserContext, GenericBeanDefinition listenerContainerDefinition) {
        return new ParserContext(parserContext.getReaderContext(), parserContext.getDelegate(), (BeanDefinition)listenerContainerDefinition);
    }

    static {
        BEAN_REFERENCE_PROPERTIES.put("connection-factory", "connectionFactory");
        BEAN_REFERENCE_PROPERTIES.put("message-converter", "messageConverter");
        BEAN_REFERENCE_PROPERTIES.put("routing-key-resolver", "routingKeyResolver");
        BEAN_REFERENCE_PROPERTIES.put("serializer", "serializer");
        BEAN_VALUE_PROPERTIES.put("durable", "durable");
        BEAN_VALUE_PROPERTIES.put("transactional", "transactional");
        BEAN_VALUE_PROPERTIES.put("wait-for-publisher-ack", "waitForPublisherAck");
        BEAN_VALUE_PROPERTIES.put("exchange-name", "exchangeName");
    }
}

